<?php if ('layout_two' == $settings['layout_type']) : ?>
  <!-- cta-six section start -->
  <div class="cta-six">
    <div class="cta-six__bg" style="background-image: url(<?php echo esc_url($settings['layout_two_bg_image']['url']); ?>);"></div>
    <div class="container">
      <div class="row align-items-center">
        <div class="col-lg-6">
          <div class="cta-six__left wow fadeInLeft" data-wow-duration='1000ms' data-wow-delay='500ms'>
            <div class="cta-six__content">
              <h2 class="cta-six__title"><?php echo wp_kses($settings['layout_two_title'], 'hostom_allowed_tags'); ?></h2>
              <p class="cta-six__text"><?php echo wp_kses($settings['layout_two_summary'], 'hostom_allowed_tags'); ?></p>
            </div>
            <div class="cta-six__form">
              <form action="#" data-url="<?php echo esc_html($settings['layout_two_mailchimp_url']); ?>" class="mc-form">
                <input type="email" name="EMAIL" placeholder="<?php echo esc_attr($settings['layout_two_mc_input_placeholder']); ?>">
                <button type="submit" class="hostom-btn"><?php echo esc_html($settings['layout_two_btn_label']); ?></button>
              </form>
            </div>
          </div>
        </div>
        <div class="col-lg-6">
          <div class="cta-six__right wow fadeInRight" data-wow-duration='1000ms' data-wow-delay='500ms'>
            <div class="cta-six__thumb">
              <?php hostom_elementor_rendered_image($settings, 'layout_two_image'); ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- cta-six section start -->
<?php endif; ?>