<?php if ('layout_one' == $settings['layout_type']) : ?>

    <div class="portfolio-details__right">
        <ul class="portfolio-details__info-list list-unstyled">
            <?php foreach ($settings['case_info'] as $item) : ?>
                <li><span><?php echo esc_html($item['title']); ?>:</span><?php echo esc_html($item['content']); ?></li>
            <?php endforeach; ?>
        </ul>
        <div class="portfolio-details__socials">
            <?php foreach ($settings['social_icons'] as $social_icon) : ?>
                <a <?php echo esc_attr(!empty($social_icon['social_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($social_icon['social_url']['url']); ?>">
                    <?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true'], 'i'); ?>
                </a>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>