<?php if ('layout_one' === $settings['layout_type']) : ?>
    <section class="product-one product-one--page">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="product-one__carousel hostom-owl__carousel hostom-owl__carousel--with-shadow hostom-owl__carousel--basic-nav owl-carousel owl-theme" data-owl-options='<?php echo esc_attr(hostom_get_owl_options($settings)); ?>'>
                        <?php
                        if (!empty($settings['select_category'])) :
                            $shop_post_query = new \WP_Query(array(
                                'post_type' => 'product',
                                'posts_per_page' => $settings['post_count']['size'],
                                'orderby' => 'menu_order title',
                                'order'   => $settings['query_order'],
                                'tax_query' => array(
                                    array(
                                        'taxonomy' => 'product_cat',
                                        'field' => 'slug',
                                        'terms' => $settings['select_category']
                                    )
                                )
                            ));

                        else :

                            $shop_post_query = new \WP_Query(array(
                                'post_type' => 'product',
                                'posts_per_page' => $settings['post_count']['size'],
                                'orderby' => 'menu_order title',
                                'order'   => $settings['query_order'],
                            ));

                        endif;
                        $i = 1;
                        while ($shop_post_query->have_posts()) :
                            $shop_post_query->the_post();
                            global $product;

                            $currency_symbol = get_woocommerce_currency_symbol();
                            $discount_price = get_post_meta(get_the_ID(), '_price', true);
                            $regular_price = get_post_meta(get_the_ID(), '_regular_price', true);
                        ?>
                            <div class="item">
                                <div class="product__item wow fadeInUp" data-wow-duration='1500ms' data-wow-delay='000ms'>
                                    <div class="product__item__img">
                                        <?php the_post_thumbnail('hostom_woo_208X208'); ?>
                                        <div class="product__item__btn">
                                            <?php
                                            if (class_exists('WPCleverWoosw')) {
                                                echo do_shortcode('[woosw]');
                                            }
                                            ?>

                                            <?php
                                            if (class_exists('WPCleverWoosq')) {
                                                echo do_shortcode('[woosq]');
                                            }
                                            ?>
                                        </div>
                                    </div><!-- /.product-image -->
                                    <div class="product__item__content">
                                        <h4 class="product__item__title">
                                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        </h4><!-- /.product-title -->
                                        <div class="product__item__price"><?php echo woocommerce_template_loop_price(); ?></div><!-- /.product-price -->
                                        <div class="product__item__ratings">
                                            <?php echo woocommerce_template_loop_rating(); ?>
                                        </div><!-- /.product-ratings -->
                                        <?php
                                        $hostom_ajax_cart_class = (get_option('woocommerce_enable_ajax_add_to_cart') == 'yes' ? 'hostom_ajax' : '');
                                        if ($product->is_type('variable')) {

                                            echo sprintf(
                                                '<a href="%s" class="%s">%s</a>',
                                                esc_url($product->add_to_cart_url()),
                                                esc_attr(implode(' ', array_filter(array(
                                                    'button', 'product_type_' . $product->get_type(),
                                                    'product__all-btn add_to_cart_button thm-btn hostom-btn hostom-btn--secondary product__item__link'
                                                )))),
                                                esc_html($product->add_to_cart_text())
                                            );
                                        } else {
                                            echo sprintf(
                                                '<a href="%s" data-quantity="1" class="%s" %s>%s</a>',
                                                esc_url($product->add_to_cart_url()),
                                                esc_attr(implode(' ', array_filter(array(
                                                    'button', 'product_type_' . $product->get_type(),
                                                    $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                                                    $product->supports('ajax_add_to_cart') ? 'thm-btn hostom-btn hostom-btn--secondary product__item__link product__all-btn add_to_cart_button ajax_add_to_cart' : 'thm-btn hostom-btn hostom-btn--secondary product__item__link shop-one__cart add_to_cart_button ',
                                                    $hostom_ajax_cart_class
                                                )))),
                                                wc_implode_html_attributes(array(
                                                    'data-product_id'  => $product->get_id(),
                                                    'data-product_sku' => $product->get_sku(),
                                                    'aria-label'       => $product->add_to_cart_description(),
                                                    'rel'              => 'nofollow',
                                                )),
                                                esc_html($product->add_to_cart_text())
                                            );
                                        }
                                        ?>
                                    </div><!-- /.product-content -->
                                </div><!-- /.product-item -->
                            </div><!-- /.item -->
                        <?php $i++;
                        endwhile;
                        wp_reset_postdata(); ?>
                    </div><!-- /.row -->
                </div><!-- /.col-lg-12 -->
            </div><!-- /.row -->
        </div><!-- /.container -->
    </section><!-- /.product-one product-one__page -->
<?php endif; ?>