<?php if ('layout_two' === $settings['layout_type']) : ?>
	<section class="service-two">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="sec-title text-center wow fadeInUp" data-wow-duration='700ms'>
						<?php
						if (!empty($settings['layout_two_sec_sub_title'])) :
							$this->add_inline_editing_attributes('layout_two_sec_sub_title', 'none');
							hostom_elementor_rendered_content($this, 'layout_two_sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_two']);
						endif;

						if (!empty($settings['layout_two_sec_title'])) :
							$this->add_inline_editing_attributes('layout_two_sec_title', 'none');
							hostom_elementor_rendered_content($this, 'layout_two_sec_title', 'sec-title__title', $settings['section_title_tag_layout_two']);
						endif;
						?>
					</div><!-- /.sec-title -->
				</div><!-- /.col-12 -->
			</div><!-- /.row -->
			<div class="row gutter-y-30">
				<?php
				$i = 1;
				foreach ($settings['layout_two_service_items'] as $index => $item) :
				?>
					<div class="col-lg-4 col-md-6">
						<div class="service-two__item wow fadeInUp" data-wow-duration="1000ms" data-wow-delay="500ms">
							<div class="service-two__item__icon">
								<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?>
							</div><!-- /.service-two__item__icon -->
							<div class="service-two__item__content">
								<<?php echo esc_attr($item['service_title_tag_layout_two']); ?> class="service-two__item__title">
									<a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?>><?php echo wp_kses($item['title'], 'hostom_allowed_tags'); ?></a>
								</<?php echo esc_attr($item['service_title_tag_layout_two']); ?>><!-- /.service-two__item__title -->
								<p class="service-two__item__text"><?php echo wp_kses($item['summary_text'], 'hostom_allowed_tags'); ?></p><!-- /.service-two__item__text -->
							</div><!-- /.service-two__item__content -->
						</div><!-- /.service-two__item -->
					</div><!-- /.col-md-4 col-sm-6 -->
				<?php
				endforeach; ?>
			</div><!-- /.row -->
		</div><!-- /.container -->
		<div class="service-two__shape service-two__shape--one">
			<?php hostom_elementor_rendered_image($settings, 'layout_two_shape_one'); ?>
		</div>
		<div class="service-two__shape service-two__shape--two">
			<?php hostom_elementor_rendered_image($settings, 'layout_two_shape_two'); ?>
		</div>
	</section><!-- / -->
<?php endif; ?>