<?php if ('layout_six' === $settings['layout_type']) : ?>
    <section class="service-five">
        <div class="container">
            <div class="service-five__inner">
                <div class="service-five__left">
                    <div class="service-five__thumb" style="background-image: url(<?php echo esc_url($settings['layout_six_bg_image']['url']); ?>);"></div>
                </div>
                <div class="service-five__right">
                    <ul class="service-five__list list-unstyled ml-0">
                        <?php
                        $i = 1;
                        foreach ($settings['service_list_six'] as $index => $item) :
                        ?>
                            <li class="service-five__list__item">
                                <div class="service-five__list__item__icon">
                                    <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?>
                                </div>
                                <div class="service-five__list__item__content">
                                    <h4 class="service-five__list__item__title">
                                        <a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?>><?php echo wp_kses($item['title'], 'hostom_allowed_tags'); ?></a>
                                    </h4>
                                    <p class="service-five__list__item__text"><?php echo wp_kses($item['summary'], 'hostom_allowed_tags'); ?></p>
                                </div>
                            </li>
                        <?php
                        endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>