<?php if ('layout_one' === $settings['layout_type']) : ?>
	<section class="service-one">
		<?php if ($settings['layout_one_bg_image']['url']) : ?>
			<div class="service-one__bg" style="background-image: url(<?php echo esc_url($settings['layout_one_bg_image']['url']); ?>);"></div><!-- / -->
		<?php endif; ?>
		<div class="container">
			<div class="row gutter-y-30">
				<div class="col-xl-5">
					<div class="service-one__left">
						<div class="service-one__top">
							<div class="sec-title text-start wow fadeInUp" data-wow-duration='700ms'>
								<?php
								if (!empty($settings['sec_sub_title'])) :
									$this->add_inline_editing_attributes('sec_sub_title', 'none');
									hostom_elementor_rendered_content($this, 'sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_one']);
								endif;

								if (!empty($settings['sec_title'])) :
									$this->add_inline_editing_attributes('sec_title', 'none');
									hostom_elementor_rendered_content($this, 'sec_title', 'sec-title__title', $settings['section_title_tag_layout_one']);
								endif;
								?>
							</div><!-- /.sec-title -->
							<p class="service-one__top__text"><?php echo wp_kses($settings['sec_summary_text'], 'hostom_allowed_tags'); ?></p><!-- /.about-three__top__text -->
						</div><!-- /.service-one__top -->
						<?php if (!empty($settings['layout_one_button_label'])) : ?>
							<div class="service-one__btn">
								<a href="<?php echo esc_url($settings['layout_one_button_url']['url']); ?>" <?php esc_attr(!empty($settings['layout_one_button_url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn hostom-btn--base"><?php echo wp_kses($settings['layout_one_button_label'], 'hostom_allowed_tags'); ?></a>
							</div><!-- /.service-one__btn -->
						<?php endif; ?>
					</div><!-- /.service-one__left -->
				</div><!-- /.col-xl-5 -->
				<div class="col-xl-7">
					<div class="service-one__right">
						<div class="row gutter-y-30 gutter-x-20">
							<?php
							$i = 1;
							foreach ($settings['service_list_one'] as $index => $item) :
							?>
								<div class="col-md-4 col-sm-6">
									<div class="service-one__card wow fadeInUp" data-wow-duration="1000ms" data-wow-delay="500ms">
										<div class="service-one__card__thumb">
											<?php hostom_elementor_rendered_image($item, 'image'); ?>
										</div><!-- /.service-one__card__thumb -->
										<div class="service-one__card__icon">
											<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?>
										</div><!-- /.service-one__card__icon -->
										<div class="service-one__card__content">
											<<?php echo esc_attr($item['service_title_tag_layout_one']); ?> class="service-one__card__title">
												<a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?>><?php echo wp_kses($item['title'], 'hostom_allowed_tags'); ?></a>
											</<?php echo esc_attr($item['service_title_tag_layout_one']); ?>><!-- /.service-one__card__title -->
											<p class="service-one__card__text"><?php echo wp_kses($item['summary_text'], 'hostom_allowed_tags'); ?></p><!-- /.service-one__card__text -->
										</div><!-- /.service-one__card__content -->
									</div><!-- /.service-one__card -->
								</div><!-- /.col-md-4 -->
							<?php $i++;
							endforeach; ?>

						</div><!-- /.row -->
					</div><!-- /.service-one__left -->
				</div><!-- /.col-xl-5 -->
			</div><!-- /.row -->
		</div><!-- /.container -->
	</section><!-- /.service-one -->
<?php endif; ?>