<?php if ('layout_four' === $settings['layout_type']) : ?>
	<!-- service-three section start -->
	<section class="service-three">
		<div class="service-three__bg" style="background-image: url(<?php echo esc_url($settings['layout_four_bg_shape']['url']); ?>);"></div>
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="sec-title text-center wow fadeInUp" data-wow-duration='700ms'>
						<?php
						if (!empty($settings['layout_four_sec_sub_title'])) :
							$this->add_inline_editing_attributes('layout_four_sec_sub_title', 'none');
							hostom_elementor_rendered_content($this, 'layout_four_sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_four']);
						endif;

						if (!empty($settings['layout_four_sec_title'])) :
							$this->add_inline_editing_attributes('layout_four_sec_title', 'none');
							hostom_elementor_rendered_content($this, 'layout_four_sec_title', 'sec-title__title', $settings['section_title_tag_layout_four']);
						endif;
						?>
					</div><!-- /.sec-title -->
				</div>
			</div>
			<div class="row gutter-y-30">
				<?php
				$i = 1;
				foreach ($settings['service_list_four'] as $index => $item) :
				?>
					<div class="col-lg-4 col-md-6">
						<div class="service-three__card <?php echo esc_attr($i == 2 ? 'service-three__card--two' : ''); ?> wow fadeInUp" data-wow-duration='1000ms' data-wow-delay='500ms'>
							<div class="service-three__item">
								<div class="service-three__inner">
									<div class="service-three__icon">
										<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?>
									</div>
									<div class="service-three__content">
										<<?php echo esc_attr($item['service_title_tag_layout_four']); ?> class="service-three__title">
											<a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?>><?php echo wp_kses($item['title'], 'hostom_allowed_tags'); ?></a>
										</<?php echo esc_attr($item['service_title_tag_layout_four']); ?>>
										<p class="service-three__text"><?php echo wp_kses($item['summary'], 'hostom_allowed_tags'); ?></p>
									</div>
								</div>
							</div>
							<div class="service-three__item">
								<div class="service-three__inner">
									<div class="service-three__icon">
										<?php \Elementor\Icons_Manager::render_icon($item['icon_two'], ['aria-hidden' => 'true'], 'i'); ?>
									</div>
									<div class="service-three__content">
										<<?php echo esc_attr($item['service_title_two_tag_layout_four']); ?> class="service-three__title">
											<a href="<?php echo esc_url($item['url_two']['url']); ?>" <?php esc_attr(!empty($item['url_two']['is_external']) ? "target=_blank" : ' '); ?>><?php echo wp_kses($item['title_two'], 'hostom_allowed_tags'); ?></a>
										</<?php echo esc_attr($item['service_title_two_tag_layout_four']); ?>>
										<p class="service-three__text"><?php echo wp_kses($item['summary_two'], 'hostom_allowed_tags'); ?> </p>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php $i++;
				endforeach; ?>
			</div>
		</div>
	</section>
	<!-- service-three section end -->
<?php endif; ?>