<?php if ('layout_five' === $settings['layout_type']) : ?>

    <!-- service-fore section start -->
    <section class="service-fore">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <ul class="service-fore__inner list-unstyled wow fadeInUp ml-0" data-wow-duration='1000ms' data-wow-delay='800ms'>
                        <?php
                        $i = 1;
                        foreach ($settings['service_list_five'] as $index => $item) :
                        ?>
                            <li class="service-fore__inner__item">
                                <div class="service-fore__inner__content">
                                    <div class="service-fore__inner__icon">
                                        <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?>
                                    </div>
                                    <<?php echo esc_attr($item['service_title_tag_layout_five']); ?> class="service-fore__inner__title">
                                        <a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?>><?php echo wp_kses($item['title'], 'hostom_allowed_tags'); ?></a>
                                    </<?php echo esc_attr($item['service_title_tag_layout_five']); ?>>
                                    <p class="service-fore__inner__text"><?php echo wp_kses($item['summary'], 'hostom_allowed_tags'); ?></p>
                                    <a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?>><i class="icon-next-1"></i></a>
                                </div>
                            </li>
                        <?php
                        endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
        <div class="service-fore__shape">
            <?php hostom_elementor_rendered_image($settings, 'layout_five_bg_image'); ?>
        </div>
    </section>
    <!-- service-fore section end -->

<?php endif; ?>