<?php if ('layout_eight' === $settings['layout_type']) : ?>
    <section class="service-page">
        <div class="container">
            <div class="service-page__carousel hostom-owl__carousel hostom-owl__carousel--with-shadow hostom-owl__carousel--basic-nav owl-carousel owl-theme" data-owl-options='<?php echo esc_attr(hostom_get_owl_options($settings)); ?>'>
                <?php
                $i = 1;
                foreach ($settings['service_list_eight'] as $index => $item) :
                ?>
                    <div class="item">
                        <div class="service-card-two wow fadeInUp" data-wow-duration="1500ms" data-wow-delay="000ms">
                            <div class="service-card-two__bg" style="background-image: url(<?php echo esc_url($item['bg_image']['url']); ?>);"></div><!-- /.service-card-two__bg -->
                            <div class="service-card-two__inner">
                                <div class="service-card-two__icon">
                                    <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?>
                                </div><!-- /.service-card-two__price -->
                                <div class="service-card-two__content">
                                    <h3 class="service-card-two__title">
                                        <a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?>><?php echo wp_kses($item['title'], 'hostom_allowed_tags'); ?></a>
                                    </h3><!-- /.service-card-two__title -->
                                    <p class="service-card-two__text"><?php echo wp_kses($item['summary'], 'hostom_allowed_tags'); ?></p><!-- /.service-card-two__text -->
                                    <div class="service-card-two__link">
                                        <a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn"><i class="icon-right-arrow"></i></a><!-- /.blog-card__link -->
                                    </div><!-- /.service-card-two__link -->
                                </div><!-- /.service-card-two__content -->
                            </div><!-- / -->
                            <div class="service-card-two__hover">
                                <div class="service-card-two__hover__content">
                                    <h3 class="service-card-two__hover__title">
                                        <a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?>><?php echo wp_kses($item['title'], 'hostom_allowed_tags'); ?></a>
                                    </h3><!-- /.service-card-two__hover__title -->
                                    <p class="service-card-two__hover__text"><?php echo wp_kses($item['summary'], 'hostom_allowed_tags'); ?></p><!-- /.service-card-two__hover__text -->
                                    <div class="service-card-two__hover__link">
                                        <a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn"><i class="icon-right-arrow"></i></a><!-- /.blog-card__link -->
                                    </div><!-- /.service-card-two__hover__link -->
                                </div><!-- /.service-card-two__hover__content -->
                            </div><!-- /.service-card-two__hover__hover -->
                        </div><!-- /.service-card-two -->
                    </div><!-- /.item -->
                <?php endforeach; ?>
            </div><!-- /.row -->
        </div><!-- /.container -->
    </section><!-- /.service-page -->
<?php endif; ?>