<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!-- Work Process Start -->
    <section class="work-process-one">
        <div class="container">
            <?php if (!empty($settings['sec_sub_title'] || $settings['sec_title'])) : ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="sec-title">
                            <?php hostom_elementor_rendered_image($settings, 'layout_one_title_img', 'sec-title__img'); ?>
                            <?php
                            if (!empty($settings['sec_sub_title'])) :
                                $this->add_inline_editing_attributes('sec_sub_title', 'none');
                                hostom_elementor_rendered_content($this, 'sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_one']);
                            endif;

                            if (!empty($settings['sec_title'])) :
                                $this->add_inline_editing_attributes('sec_title', 'none');
                                hostom_elementor_rendered_content($this, 'sec_title', 'sec-title__title', $settings['section_title_tag_layout_one']);
                            endif;
                            ?>
                        </div><!-- /.sec-title -->
                        <!-- section-title -->
                    </div>
                </div>
            <?php endif; ?>
            <div class="row">
                <div class="col-lg-12 wow fadeInUp animated" data-wow-delay="500ms">
                    <div class="work-process-one__border"><span class="work-process-one__gradiant-left"></span><span class="work-process-one__gradiant-right"></span></div>
                </div>
            </div>
            <div class="row">
                <?php foreach ($settings['process_list'] as $index => $item) :  ?>
                    <div class="col-lg-4 col-md-6 wow fadeInUp animated" data-wow-delay="<?php echo esc_attr($index + 1); ?>00ms">
                        <div class="work-process-one__item text-center">
                            <div class="work-process-one__item__thumb">
                                <div class="work-process-one__item__thumb-wrap">
                                    <?php hostom_elementor_rendered_image($item, 'image'); ?>
                                </div>
                                <div class="work-process-one__item__thumb__icon">
                                    <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'span'); ?>
                                </div><!-- /.work-process-icon -->
                                <div class="work-process-one__item__thumb__number"></div><!-- /.work-process-number -->
                            </div><!-- /.work-process-image -->
                            <div class="work-process-one__item__content">
                                <<?php echo esc_attr($item['process_title_tag_layout_one']); ?> class="work-process-one__item__title">
                                    <?php echo wp_kses($item['title'], 'hostom_allowed_tags'); ?>
                                </<?php echo esc_attr($item['process_title_tag_layout_one']); ?>><!-- /.work-process-title -->
                                <p class="work-process-one__item__text">
                                    <?php echo wp_kses($item['subtitle'], 'hostom_allowed_tags'); ?>
                                </p><!-- /.work-process-text -->
                            </div>
                        </div><!-- /.work-process-item -->
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <!-- Work Process End -->
<?php endif; ?>