<?php if ('layout_three' == $settings['layout_type']) : ?>
    <!-- pricing-two section start -->
    <section class="pricing-two">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="tables wow fadeInUp" data-wow-duration='1000ms' data-wow-delay='500ms'>
                        <table class="pricing-two__table">
                            <thead class="pricing-two__table__head">
                                <tr>
                                    <th class="pricing-two__table__head__item">
                                        <div class="sec-title">
                                            <div class="tagline"><?php echo wp_kses($settings['layout_three_sec_sub_title'], 'hostom_allowed_tags'); ?></div><!-- /.sec-title__tagline -->
                                            <div class="title"><?php echo wp_kses($settings['layout_three_sec_title'], 'hostom_allowed_tags'); ?></div><!-- /.sec-title__title -->
                                        </div><!-- /.sec-title -->
                                    </th>

                                    <th class="pricing-two__table__head__item">
                                        <div class="pricing-two__table__head__item__thumb">
                                            <?php hostom_elementor_rendered_image($settings, 'layout_three_package_one_image'); ?>
                                        </div>
                                        <div class="pricing-two__table__head__item__title"><?php echo wp_kses($settings['layout_three_package_one_title'], 'hostom_allowed_tags'); ?></div>
                                        <div class="pricing-two__table__head__item__price">
                                            <span class="pricing-two__table__head__item__price__price"><?php echo wp_kses($settings['layout_three_package_one_price'], 'hostom_allowed_tags'); ?></span>
                                            <p class="pricing-two__table__head__item__price__month"><?php echo wp_kses($settings['layout_three_package_one_duration'], 'hostom_allowed_tags'); ?></p>
                                        </div>
                                    </th>

                                    <th class="pricing-two__table__head__item">
                                        <div class="pricing-two__table__head__item__thumb">
                                            <?php hostom_elementor_rendered_image($settings, 'layout_three_package_two_image'); ?>
                                        </div>
                                        <div class="pricing-two__table__head__item__title"><?php echo wp_kses($settings['layout_three_package_two_title'], 'hostom_allowed_tags'); ?></div>
                                        <div class="pricing-two__table__head__item__price">
                                            <span class="pricing-two__table__head__item__price__price"><?php echo wp_kses($settings['layout_three_package_two_price'], 'hostom_allowed_tags'); ?></span>
                                            <p class="pricing-two__table__head__item__price__month"><?php echo wp_kses($settings['layout_three_package_two_duration'], 'hostom_allowed_tags'); ?></p>
                                        </div>
                                    </th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 0;
                                foreach ($settings['layout_three_features'] as $features) : ?>
                                    <tr>
                                        <td>
                                            <p class="pricing-two__table__text"><?php echo esc_html($features['title']); ?></p>
                                        </td>
                                        <td>
                                            <?php if ('yes' ==  $settings['layout_three_package_two_features_availability'][$i]['is_available']) : ?>
                                                <div class="pricing-two__table__icon">
                                                    <i class="icon-mark-2"></i>
                                                </div>
                                            <?php else : ?>
                                                <div class="pricing-two__table__icon pricing-two__table__icon--two">
                                                    <i class="icon-close"></i>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if ('yes' ==  $settings['layout_three_package_two_features_availability'][$i]['is_available']) : ?>
                                                <div class="pricing-two__table__icon">
                                                    <i class="icon-mark-2"></i>
                                                </div>
                                            <?php else : ?>
                                                <div class="pricing-two__table__icon pricing-two__table__icon--two">
                                                    <i class="icon-close"></i>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php
                                    $i++;
                                endforeach;
                                ?>
                                <tr>
                                    <td></td>
                                    <?php if (!empty($settings['layout_three_package_one_button_label'])) : ?>
                                        <td>
                                            <div class="pricing-two__table__btn">
                                                <a href="<?php echo esc_url($settings['layout_three_package_one_button_url']['url']); ?>" <?php esc_attr(!empty($settings['layout_three_package_one_button_url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn"><?php echo esc_html($settings['layout_three_package_one_button_label']); ?></a>
                                            </div>
                                        </td>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['layout_three_package_two_button_label'])) : ?>
                                        <td>
                                            <div class="pricing-two__table__btn">
                                                <a href="<?php echo esc_url($settings['layout_three_package_two_button_url']['url']); ?>" <?php esc_attr(!empty($settings['layout_three_package_two_button_url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn"><?php echo esc_html($settings['layout_three_package_two_button_label']); ?></a>
                                            </div>
                                        </td>
                                    <?php endif; ?>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- pricing-two section start -->
<?php endif; ?>