<?php if ('layout_one' == $settings['layout_type']) : ?>
    <section class="package-one">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="sec-title text-center wow fadeInUp" data-wow-duration='700ms'>
                        <?php
                        if (!empty($settings['sec_sub_title'])) :
                            $this->add_inline_editing_attributes('sec_sub_title', 'none');
                            hostom_elementor_rendered_content($this, 'sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_one']);
                        endif;

                        if (!empty($settings['sec_title'])) :
                            $this->add_inline_editing_attributes('sec_title', 'none');
                            hostom_elementor_rendered_content($this, 'sec_title', 'sec-title__title', $settings['section_title_tag_layout_one']);
                        endif;
                        ?>
                    </div><!-- /.sec-title -->
                </div><!-- /.col-md-12 -->
            </div><!-- /.row -->
            <div class="tabs-box">
                <div class="price-page wow fadeInUp" data-wow-delay='500ms'>
                    <div class="price-page__inner__filter text-center">
                        <button data-tab="#monthly" class="price-page__inner__btn hostom-btn tab-btn active-btn"><?php echo wp_kses($settings['monthly_heading'], 'hostom_allowed_tags'); ?></button><!-- /.price-page__inner__btn -->
                        <button data-tab="#yearly" class="price-page__inner__btn hostom-btn tab-btn"><?php echo wp_kses($settings['yearly_heading'], 'hostom_allowed_tags'); ?></button><!-- /.price-page__inner__btn -->
                    </div><!-- /.contact-location__inner__filter -->
                </div><!-- /.price-page__inner -->
                <div class="tabs-content">
                    <div class="price-page__inner__item fadeInUp animated tab active-tab" id="monthly">
                        <div class="row gutter-y-30">
                            <?php foreach ($settings['pricing_monthly_list'] as $index => $item) :  ?>
                                <div class="col-md-6 col-lg-4">
                                    <div class="package-card price wow fadeInUp" data-wow-duration='700ms'>
                                        <div class="package-card__head">
                                            <div class="package-card__head__thumb">
                                                <?php hostom_elementor_rendered_image($item, 'image'); ?>
                                            </div><!-- /.package-card__head__thumb -->
                                            <h3 class="package-card__head__title"><?php echo wp_kses($item['plan_title'], 'hostom_allowed_tags'); ?></h3><!-- /.package-card__head__title -->
                                        </div><!-- /.package-card__head -->
                                        <div class="package-card__body">
                                            <div class="package-card__body__top">
                                                <h3 class="package-card__body__pricing-plan"><?php echo wp_kses($item['plan_type'], 'hostom_allowed_tags'); ?></h3><!-- /.package-card__head__title -->
                                                <div class="package-card__body__price"><?php echo wp_kses($item['price'], 'hostom_allowed_tags'); ?> <span class="package-card__body__price__month"><?php echo wp_kses($item['duration'], 'hostom_allowed_tags'); ?></span></div><!-- /.package-card__head__price -->
                                            </div><!-- /.package-card__body__top -->
                                            <div class="package-card__content">
                                                <ul class="package-card__content__list list-unstyled ml-0">
                                                    <?php echo wp_kses($item['service_list'], 'hostom_allowed_tags'); ?>
                                                </ul><!-- /.package-card__content__item -->
                                                <?php if (!empty($item['button_label'])) : ?>
                                                    <div class="package-card__content__link">
                                                        <a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn hostom-btn--secondary"><?php echo esc_html($item['button_label']); ?></a>
                                                    </div><!-- /.package-card__content__link -->
                                                <?php endif; ?>
                                            </div><!-- /.package-card__content -->
                                        </div><!-- /.package-card__body -->
                                    </div><!-- /.package-card -->
                                </div><!-- /.col-md-6 col-lg-4 -->
                            <?php endforeach; ?>
                        </div><!-- /.row -->
                    </div><!-- / -->
                    <div class="price-page__inner__item fadeInUp animated tab" id="yearly">
                        <div class="row gutter-y-30">
                            <?php foreach ($settings['pricing_yearly_list'] as $index => $item) :  ?>
                                <div class="col-md-6 col-lg-4">
                                    <div class="package-card price wow fadeInUp" data-wow-duration='700ms'>
                                        <div class="package-card__head">
                                            <div class="package-card__head__thumb">
                                                <?php hostom_elementor_rendered_image($item, 'image'); ?>
                                            </div><!-- /.package-card__head__thumb -->
                                            <h3 class="package-card__head__title"><?php echo wp_kses($item['plan_title'], 'hostom_allowed_tags'); ?></h3><!-- /.package-card__head__title -->
                                        </div><!-- /.package-card__head -->
                                        <div class="package-card__body">
                                            <div class="package-card__body__top">
                                                <h3 class="package-card__body__pricing-plan"><?php echo wp_kses($item['plan_type'], 'hostom_allowed_tags'); ?></h3><!-- /.package-card__head__title -->
                                                <div class="package-card__body__price"> <?php echo wp_kses($item['price'], 'hostom_allowed_tags'); ?> <span class="package-card__body__price__month"><?php echo wp_kses($item['duration'], 'hostom_allowed_tags'); ?></span></div><!-- /.package-card__head__price -->
                                            </div><!-- /.package-card__body__top -->
                                            <div class="package-card__content">
                                                <ul class="package-card__content__list list-unstyled ml-0">
                                                    <?php echo wp_kses($item['service_list'], 'hostom_allowed_tags'); ?>
                                                </ul><!-- /.package-card__content__item -->
                                                <?php if (!empty($item['button_label'])) : ?>
                                                    <div class="package-card__content__link">
                                                        <a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn hostom-btn--secondary"><?php echo esc_html($item['button_label']); ?></a>
                                                    </div><!-- /.package-card__content__link -->
                                                <?php endif; ?>
                                            </div><!-- /.package-card__content -->
                                        </div><!-- /.package-card__body -->
                                    </div><!-- /.package-card -->
                                </div><!-- /.col-md-6 col-lg-4 -->
                            <?php endforeach; ?>
                        </div><!-- /.row -->
                    </div><!-- / -->
                </div><!-- / -->
            </div><!-- /.tabs-box -->
        </div><!-- /.container -->
    </section><!-- /.package-one -->
<?php endif; ?>