<?php if ('layout_five' == $settings['layout_type']) : ?>
    <section class="package-page">
        <div class="container">
            <div class="package-page__carousel hostom-owl__carousel hostom-owl__carousel--with-shadow hostom-owl__carousel--basic-nav owl-carousel owl-theme" data-owl-options='<?php echo esc_attr(hostom_get_owl_options($settings)); ?>'>
                <?php foreach ($settings['layout_five_pricing_list'] as $index => $item) :  ?>
                    <div class="item">
                        <div class="package-card price wow fadeInUp" data-wow-duration='700ms'>
                            <div class="package-card__head">
                                <div class="package-card__head__thumb">
                                    <?php hostom_elementor_rendered_image($item, 'image'); ?>
                                </div><!-- /.package-card__head__thumb -->
                                <h3 class="package-card__head__title"><?php echo wp_kses($item['plan_title'], 'hostom_allowed_tags'); ?></h3><!-- /.package-card__head__title -->
                            </div><!-- /.package-card__head -->
                            <div class="package-card__body">
                                <div class="package-card__body__top">
                                    <h3 class="package-card__body__pricing-plan"><?php echo wp_kses($item['plan_type'], 'hostom_allowed_tags'); ?></h3><!-- /.package-card__head__title -->
                                    <div class="package-card__body__price"> <?php echo wp_kses($item['price'], 'hostom_allowed_tags'); ?> <span class="package-card__body__price__month"><?php echo wp_kses($item['duration'], 'hostom_allowed_tags'); ?></span></div><!-- /.package-card__head__price -->
                                </div><!-- /.package-card__body__top -->
                                <div class="package-card__content">
                                    <ul class="package-card__content__list list-unstyled ml-0">
                                        <?php echo wp_kses($item['service_list'], 'hostom_allowed_tags'); ?>
                                    </ul><!-- /.package-card__content__item -->
                                    <?php if (!empty($item['button_label'])) : ?>
                                        <div class="package-card__content__link">
                                            <a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn hostom-btn--secondary"><?php echo esc_html($item['button_label']); ?></a>
                                        </div><!-- /.package-card__content__link -->
                                    <?php endif; ?>
                                </div><!-- /.package-card__content -->
                            </div><!-- /.package-card__body -->
                        </div><!-- /.package-card -->
                    </div><!-- /.item -->
                <?php endforeach; ?>
            </div><!-- /.row -->
        </div><!-- /.container -->
    </section><!-- /.package-page -->
<?php endif; ?>