<?php if ('layout_two' == $settings['layout_type']) : ?>
    <!-- Portfolio Start -->
    <section class="portfolio-two">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <?php if (!empty($settings['layout_two_sec_sub_title']) || !empty($settings['layout_two_sec_title'])) : ?>
                        <div class="section-title text-center">
                            <div class="section-title__triangle">
                                <span class="section-title__triangle-left"></span>
                                <span class="section-title__triangle-right"></span>
                            </div>
                            <?php
                            if (!empty($settings['layout_two_sec_sub_title'])) :
                                $this->add_inline_editing_attributes('layout_two_sec_sub_title', 'none');
                                hostom_elementor_rendered_content($this, 'layout_two_sec_sub_title', 'section-title__tagline', $settings['section_sub_title_tag_layout_two']);
                            endif;

                            if (!empty($settings['layout_two_sec_title'])) :
                                $this->add_inline_editing_attributes('layout_two_sec_title', 'none');
                                hostom_elementor_rendered_content($this, 'layout_two_sec_title', 'section-title__title', $settings['section_title_tag_layout_two']);
                            endif;
                            ?>
                        </div><!-- section-title -->
                    <?php endif; ?>
                    <?php if ('yes' == $settings['layout_two_enable_filter']) : ?>
                        <ul class="portfolio-two__filter post-filter has-dynamic-filters-counter list-unstyled">
                            <li data-filter=".filter-item" class="active"><span class="filter-text"><?php esc_html_e('All', 'hostom-addon'); ?></span></li>
                            <?php foreach ($settings['layout_two_filter'] as $item) :  ?>
                                <li data-filter=".<?php echo esc_attr($item['slug']); ?>"><span class="filter-text"><?php echo esc_html($item['name']); ?></span></li>
                            <?php endforeach; ?>
                        </ul><!-- section-nav -->
                    <?php endif; ?>
                </div>
            </div>
            <div class="row hostom-masonary hostom-filter">
                <?php $i = 1;
                foreach ($settings['portfolio_two_list'] as $index => $item) :
                    if ($i == 2 || $i == 7) :
                        $class = 6;
                    else :
                        $class = 3;
                    endif;
                ?>
                    <div class="col-xl-<?php echo esc_attr($class); ?> col-md-6 filter-item <?php echo esc_attr($item['slug']); ?>">
                        <div class="portfolio-two__item portfolio-two__item-sm">
                            <div class="portfolio-two__thumb">
                                <?php hostom_elementor_rendered_image($item, 'image'); ?>
                            </div>
                            <div class="portfolio-two__hover">
                                <a class="portfolio-two__read-more" href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?>><span class="icon-right-arrow"></span></a>
                                <div class="portfolio-two__hover-bottom">
                                    <div class="portfolio-two__cats">
                                        <?php
                                        if (!empty($item['tag_line'])) :
                                            hostom_basic_rendered_content($this, $item,  'tag_line', '', 'a');
                                        endif;
                                        ?>
                                    </div>
                                    <<?php echo esc_attr($item['portfolio_title_tag_layout_two']); ?> class="portfolio-two__title">
                                        <?php
                                        if (!empty($item['title'])) :
                                            hostom_basic_rendered_content($this, $item,  'title', '', 'a');
                                        endif;
                                        ?>
                                    </<?php echo esc_attr($item['portfolio_title_tag_layout_two']); ?>>
                                </div>
                            </div>
                        </div><!-- folio-item -->
                    </div><!-- folio-columng -->
                <?php $i++;
                endforeach; ?>

            </div>
        </div>
    </section>
    <!-- Portfolio End -->
<?php endif; ?>