<?php if ('layout_five' == $settings['layout_type']) : ?>
    <!-- Portfolio Start -->
    <section class="portfolio-one portfolio-page">
        <div class="container">
            <div class="row hostom-masonary">
                <?php foreach ($settings['portfolio_five_list'] as $index => $item) :  ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="portfolio-one__item">
                            <div class="portfolio-one__thumb">
                                <?php hostom_elementor_rendered_image($item, 'image'); ?>
                            </div>
                            <div class="portfolio-one__hover">
                                <a class="portfolio-one__read-more" href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?>><span class="icon-right-arrow"></span></a>
                                <div class="portfolio-one__hover-bottom">
                                    <div class="portfolio-one__cats">
                                        <?php
                                        if (!empty($item['tag_line'])) :
                                            hostom_basic_rendered_content($this, $item,  'tag_line', '', 'a');
                                        endif;
                                        ?>
                                    </div>
                                    <<?php echo esc_attr($item['portfolio_title_tag_layout_five']); ?> class="portfolio-one__title">
                                        <?php
                                        if (!empty($item['title'])) :
                                            hostom_basic_rendered_content($this, $item,  'title', '', 'a');
                                        endif;
                                        ?>
                                    </<?php echo esc_attr($item['portfolio_title_tag_layout_five']); ?>>
                                </div>
                            </div>
                        </div><!-- folio-item -->
                    </div>
                <?php endforeach; ?>
            </div><!-- slider-end -->
        </div>
    </section>
    <!-- Portfolio End -->
<?php endif; ?>