<?php if ('layout_eight' == $settings['layout_type']) : ?>
    <!-- Portfolio Start -->
    <section class="portfolio-one portfolio-one-details">
        <div class="container">
            <div class="row">
                <div class="col-md-12 wow fadeInUp" data-wow-delay="100ms">
                    <div class="section-title text-center">
                        <div class="section-title__triangle">
                            <span class="section-title__triangle-left"></span>
                            <span class="section-title__triangle-right"></span>
                        </div>
                        <?php
                        if (!empty($settings['layout_eight_sec_sub_title'])) :
                            $this->add_inline_editing_attributes('layout_eight_sec_sub_title', 'none');
                            hostom_elementor_rendered_content($this, 'layout_eight_sec_sub_title', 'section-title__tagline', $settings['section_sub_title_tag_layout_eight']);
                        endif;

                        if (!empty($settings['layout_eight_sec_title'])) :
                            $this->add_inline_editing_attributes('layout_eight_sec_title', 'none');
                            hostom_elementor_rendered_content($this, 'layout_eight_sec_title', 'section-title__title', $settings['section_title_tag_layout_eight']);
                        endif;
                        ?>
                    </div><!-- section-title -->
                </div>
            </div>
            <div class="hostom-owl__dots hostom-owl__carousel owl-theme owl-carousel" data-owl-options='<?php echo esc_attr(hostom_get_owl_options_two($settings)); ?>'>
                <?php foreach ($settings['portfolio_eight_list'] as $index => $item) :  ?>
                    <div class="item">
                        <div class="portfolio-one__item">
                            <div class="portfolio-one__thumb">
                                <?php hostom_elementor_rendered_image($item, 'image'); ?>
                            </div>
                            <div class="portfolio-one__hover">
                                <a class="portfolio-one__read-more" href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?>><span class="icon-right-arrow"></span></a>
                                <div class="portfolio-one__hover-bottom">
                                    <div class="portfolio-one__cats">
                                        <?php
                                        if (!empty($item['tag_line'])) :
                                            hostom_basic_rendered_content($this, $item,  'tag_line', '', 'a');
                                        endif;
                                        ?>
                                    </div>
                                    <<?php echo esc_attr($item['portfolio_title_tag_layout_eight']); ?> class="portfolio-one__title">
                                        <?php
                                        if (!empty($item['title'])) :
                                            hostom_basic_rendered_content($this, $item,  'title', '', 'a');
                                        endif;
                                        ?>
                                    </<?php echo esc_attr($item['portfolio_title_tag_layout_eight']); ?>>
                                </div>
                            </div>
                        </div><!-- folio-item -->
                    </div>
                <?php endforeach; ?>
            </div><!-- slider-end -->
        </div>
    </section>
    <!-- Portfolio End -->
<?php endif; ?>