<?php if ('layout_two' === $settings['layout_type']) : ?>

	<!--Main Slider Start-->
	<section class="main-slider-two">
		<div class="main-slider-two__carousel hostom-owl__carousel owl-carousel" data-owl-options='{
		"loop": true,
		"animateOut": "fadeOut",
		"animateIn": "fadeIn",
		"items": 1,
		"autoplay": true,
		"autoplayTimeout": 7000,
		"smartSpeed": 1000,
		"nav": false,
        "navText": ["<span class=\"icon-left-arrow\"></span>","<span class=\"icon-right-arrow\"></span>"],
		"dots": true,
		"margin": 0
	    }'>
			<?php
			$i = 1;
			foreach ($settings['layout_two_sliders'] as $slider) : ?>
				<div class="item">
					<div class="main-slider-two__item">
						<div class="main-slider-two__bg">
							<?php hostom_elementor_rendered_image($slider, 'background_image'); ?>
							<?php hostom_elementor_rendered_image($slider, 'background_image'); ?>
						</div>
						<div class="container">
							<div class="row">
								<div class="col-md-12 text-center">
									<div class="main-slider-two__content">
										<<?php echo esc_attr($slider['sub_title_tag_layout_two']); ?> class="main-slider-two__sub-title">
											<?php echo wp_kses($slider['sub_title'], 'hostom_allowed_tags'); ?>
										</<?php echo esc_attr($slider['sub_title_tag_layout_two']); ?>>
										<!-- slider-sub-title -->
										<<?php echo esc_attr($slider['title_tag_layout_two']); ?> class="main-slider-two__title">
											<?php echo wp_kses($slider['title'], 'hostom_allowed_tags'); ?>
										</<?php echo esc_attr($slider['title_tag_layout_two']); ?>><!-- slider-title -->
										<div class="main-slider-two__btn">
											<a href="<?php echo esc_url($slider['button_one_url']['url']); ?>" <?php esc_attr(!empty($settings['button_one_url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn hostom-btn--base">
												<span><?php echo wp_kses($slider['button_one_label'], 'hostom_allowed_tags'); ?></span>
											</a><!-- slider-btn -->
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			<?php $i++;
			endforeach; ?>
		</div>
	</section>
	<!--Main Slider End-->

<?php endif; ?>