<?php if ('layout_three' === $settings['layout_type']) : ?>

	<!--Main Slider Start-->
	<section class="main-slider-three">
		<div class="main-slider-three__carousel hostom-owl__carousel owl-carousel" data-owl-options='<?php echo esc_attr(hostom_get_owl_options($settings)); ?>'>
			<?php
			$i = 1;
			foreach ($settings['layout_three_sliders'] as $slider) : ?>
				<div class="item">
					<div class="main-slider-three__item">
						<div class="main-slider-three__bg" style="background-image: url(<?php echo esc_url($slider['background_image_one']['url']); ?>);"></div><!-- slider-bg -->
						<div class="main-slider-three__shape-left" style="background-image: url(<?php echo esc_url($slider['shape_two']['url']); ?>);"></div><!-- slider-shape -->
						<div class="main-slider-three__shape-right" style="background-image: url(<?php echo esc_url($slider['shape_one']['url']); ?>);"></div><!-- slider-shape -->
						<div class="container">
							<div class="row">
								<div class="col-lg-6 d-flex align-items-center">
									<div class="main-slider-three__content">
										<<?php echo esc_attr($slider['sub_title_tag_layout_three']); ?> class="main-slider-three__sub-title">
											<?php echo wp_kses($slider['sub_title'], 'hostom_allowed_tags'); ?>
										</<?php echo esc_attr($slider['sub_title_tag_layout_three']); ?>><!-- slider-sub-title -->
										<<?php echo esc_attr($slider['sub_title_tag_layout_three']); ?> class="main-slider-three__title">
											<?php echo wp_kses($slider['title'], 'hostom_allowed_tags'); ?>
										</<?php echo esc_attr($slider['sub_title_tag_layout_three']); ?>><!-- slider-title -->
										<?php if (!empty($slider['button_url']['url'])) : ?>
											<div class="main-slider-three__btn">
												<a href="<?php echo esc_url($slider['button_url']['url']); ?>" <?php esc_attr(!empty($settings['button_url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn hostom-btn--base"><span><?php echo wp_kses($slider['button_label'], 'hostom_allowed_tags'); ?></span></a><!-- slider-btn -->
											</div>
										<?php endif; ?>
									</div>
								</div>
								<div class="col-lg-6 text-end">
									<div class="main-slider-three__thumb">
										<div class="main-slider-three__thumb-one">
											<?php hostom_elementor_rendered_image($slider, 'background_image_two'); ?>
										</div>
										<div class="main-slider-three__thumb-border">
											<?php hostom_elementor_rendered_image($slider, 'shape_three'); ?>
										</div>
										<div class="main-slider-three__thumb-leaf-one">
											<?php hostom_elementor_rendered_image($slider, 'shape_four'); ?>
										</div>
										<div class="main-slider-three__thumb-leaf-two">
											<?php hostom_elementor_rendered_image($slider, 'shape_five'); ?>
										</div>
										<div class="main-slider-three__thumb-flower">
											<?php hostom_elementor_rendered_image($slider, 'shape_six'); ?>
										</div>
										<?php if (!empty($slider['video_url']['url'] || $slider['video_text'])) : ?>
											<div class="main-slider-three__curved-circle-box">
												<a href="<?php echo esc_url($slider['video_url']['url']); ?>" class="video-popup">
													<i class="fa fa-play"></i>
												</a>
												<div class="curved-circle">
													<!-- curved-circle start-->
													<div class="curved-circle--item" data-circle-text-options='{
											"radius": 75,
											"forceWidth": true,
											"forceHeight": true
										}'>
														<?php echo wp_kses($slider['video_text'], 'hostom_allowed_tags'); ?>
													</div>
												</div><!-- curved-circle end-->
											</div><!-- curved-circle end-->
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			<?php $i++;
			endforeach; ?>
		</div>
	</section>
	<!--Main Slider End-->

<?php endif; ?>