<?php if ('layout_one' === $settings['layout_type']) : ?>

    <!--Main Slider Start-->
    <section class="main-slider-one">
        <div class="main-slider-one__carousel hostom-owl__carousel owl-carousel" data-owl-options='<?php echo esc_attr(hostom_get_owl_options($settings)); ?>'>
            <?php
            foreach ($settings['sliders'] as $index => $slider) :
            ?>
                <div class="item">
                    <div class="main-slider-one__item">
                        <div class="main-slider-one__bg" style="background-image: url(<?php echo esc_url($slider['background_image']['url']); ?>);"></div>
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <circle class='circle0 steap' cx="50%" cy="55%" r="5.2%" />
                            <circle class='circle1 steap' cx="50%" cy="55%" r="15.6%" />
                            <circle class='circle2 steap' cx="50%" cy="55%" r="26%" />
                            <circle class='circle3 steap' cx="50%" cy="55%" r="36.4%" />
                            <circle class='circle4 steap' cx="50%" cy="55%" r="46.8%" />
                            <circle class='circle5 steap' cx="50%" cy="55%" r="57%" />
                            <circle class='circle6 steap' cx="50%" cy="55%" r="67.7%" />
                            <circle class='circle7 steap' cx="50%" cy="55%" r="78.1%" />
                            <circle class='circle8 steap' cx="50%" cy="55%" r="88.5%" />
                            <circle class='circle9 steap' cx="50%" cy="55%" r="100%" />
                        </svg>
                        <div class="container">
                            <div class="row">
                                <div class="col-md-12 text-center">
                                    <div class="main-slider-one__content">
                                        <<?php echo esc_attr($slider['sub_title_tag_layout_one']); ?> class="main-slider-one__sub-title"><?php echo wp_kses($slider['sub_title'], 'hostom_allowed_tags'); ?> <?php hostom_elementor_rendered_image($slider, 'shape_one'); ?></<?php echo esc_attr($slider['sub_title_tag_layout_one']); ?>>
                                        <!-- slider-sub-title -->
                                        <<?php echo esc_attr($slider['title_tag_layout_one']); ?> class="main-slider-one__title"><?php echo wp_kses($slider['title'], 'hostom_allowed_tags'); ?></<?php echo esc_attr($slider['title_tag_layout_one']); ?>><!-- slider-title -->
                                        <?php if (!empty($slider['url']['url'])) : ?>
                                            <div class="main-slider-one__btn">
                                                <a href="<?php echo esc_url($slider['url']['url']); ?>" class="hostom-btn hostom-btn--base"><span><?php echo wp_kses($slider['button_label'], 'hostom_allowed_tags'); ?></span></a><!-- slider-btn -->
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </section>
    <!-- main-slider-end -->
<?php endif; ?>