<?php if ('layout_one' == $settings['layout_type']) : ?>
	<!-- Login Start -->
	<section class="login-page">
		<div class="container">

			<div class="login-page__info  wow fadeInUp" data-wow-delay='500ms'>
				<p class="login-page__info__item"><?php echo wp_kses($settings['login_info'], 'hostom_allowed_tags'); ?></p>
			</div><!-- login-info -->

			<div class="login-page__inner">
				<div class="row gutter-x-94">

					<div class="col-lg-6 wow fadeInUp animated" data-wow-delay="300ms">
						<?php if (!is_user_logged_in()) :
						?>
							<div class="login-page__wrap">
								<?php if (!empty($settings['login_title'])) : ?>
									<h3 class="login-page__wrap__title"><?php echo esc_html($settings['login_title']); ?></h3>
								<?php endif; ?>
								<form class="login-page__form" id="hostom-login">
									<div class="login-result text-center"></div>
									<?php wp_nonce_field('hostom-login-nonce', 'security'); ?>
									<div class="login-page__form-input-box">
										<input type="text" name="username" placeholder="<?php echo esc_attr($settings['login_user_name_placeholder']); ?>">
									</div>
									<div class="login-page__form-input-box">
										<input type="password" name="password" placeholder="<?php echo esc_attr($settings['login_password_placeholder']); ?>">
									</div>
									<div class="login-page__checked-box">
										<div class="login-page__checked-inner">
											<input type="checkbox" name="remember" id="remember">
											<label for="remember"><span></span><?php echo esc_html($settings['login_remember_me_text']); ?></label>
										</div>
										<div class="login-page__form-forgot-password">
											<a <?php echo esc_attr(!empty($settings['login_forget_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['login_forget_url']['url']); ?>" class="login-page__form-forgot-password__item"><?php echo esc_html($settings['login_forget_text']); ?></a>
										</div>
									</div>
									<div class="login-page__form-btn-box">
										<button type="submit" class="hostom-btn hostom-btn--secondary"><span><?php echo esc_html($settings['login_btn_text']); ?></span></button>
									</div>
								</form>

								<div class="form__border"></div>
							</div><!-- login-form -->
						<?php else :
						?>
							<div class="alert alert-success"> <?php esc_html_e('You are logged in ', 'hostom-login'); ?> </div>
							<div class="alert alert-danger"><a href="<?php echo wp_logout_url(home_url('/')); ?>"><?php echo esc_html_e('Log Out ?', 'hostom-login'); ?></a></div>
						<?php endif;
						?>
					</div>

					<div class="col-lg-6 wow fadeInUp animated" data-wow-delay="400ms">
						<?php if (!is_user_logged_in()) :
						?>
							<div class="login-page__wrap register-page__wrap">
								<?php if (!empty($settings['register_title'])) : ?>
									<h3 class="login-page__wrap__title"><?php echo esc_html($settings['register_title']); ?></h3>
								<?php endif; ?>
								<form class="login-page__form" id="hostom-registration">
									<div class="registration-result text-center"></div>
									<?php wp_nonce_field('hostom-register-nonce', 'security'); ?>
									<div class="login-page__form-input-box">
										<input type="email" placeholder="<?php echo esc_attr($settings['register_email_placeholder']); ?>" name="singupEmail">
									</div>
									<div class="login-page__form-input-box">
										<input type="password" placeholder="<?php echo esc_attr($settings['register_password_placeholder']); ?>" name="singupPassword">
									</div>
									<div class="login-page__checked-box">
										<input type="checkbox" name="term" id="term">
										<label for="term"><span></span><?php echo wp_kses($settings['register_privacy_text'], 'hostom_allowed_tags'); ?></label>
									</div>
									<div class="login-page__form-btn-box">
										<button type="submit" class="hostom-btn hostom-btn--secondary">
											<span><?php echo esc_html($settings['register_btn_text']); ?></span>
										</button>
									</div>
								</form>
							</div><!-- register-form -->
						<?php else :
						?>
							<div class="alert alert-success"> <?php esc_html_e('You are logged in ', 'hostom-login'); ?> </div>
							<div class="alert alert-danger"><a href="<?php echo wp_logout_url(home_url('/')); ?>"><?php echo esc_html_e('Log Out ?', 'hostom-login'); ?></a></div>
						<?php endif;
						?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- Login End -->
<?php endif; ?>