<?php if ('layout_one' === $settings['layout_type']) : ?>
    <section class="home-showcase">
        <div class="container">
            <div class="home-showcase__inner">
                <div class="row">
                    <?php foreach ($settings['megamenu_box_list'] as $item) :  ?>
                        <div class="col-md-6 col-lg-3">
                            <div class="demo-one__card">
                                <div class="demo-one__image">
                                    <?php hostom_elementor_rendered_image($item, 'image'); ?>
                                    <div class="demo-one__btns">
                                        <?php if (!empty($item['multi_page_title'])) : ?>
                                            <a href="<?php echo esc_url($item['multi_page_url']['url']); ?>" <?php esc_attr(!empty($item['multi_page_url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn demo-one__btn">
                                                <span><?php echo esc_html($item['multi_page_title']); ?></span>
                                            </a><!-- /.thm-btn demo-one__btn -->
                                        <?php endif; ?>
                                        <?php if (!empty($item['one_page_title'])) : ?>
                                            <a href="<?php echo esc_url($item['one_page_url']['url']); ?>" <?php esc_attr(!empty($item['one_page_url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn demo-one__btn">
                                                <span><?php echo esc_html($item['one_page_title']); ?></span>
                                            </a><!-- /.thm-btn demo-one__btn -->
                                        <?php endif; ?>
                                        <?php if (!empty($item['dark_page_title'])) : ?>
                                            <a href="<?php echo esc_url($item['dark_page_url']['url']); ?>" <?php esc_attr(!empty($item['dark_page_url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn demo-one__btn">
                                                <span><?php echo esc_html($item['dark_page_title']); ?></span>
                                            </a><!-- /.thm-btn demo-one__btn -->
                                        <?php endif; ?>
                                    </div><!-- /.demo-one__btns -->
                                </div><!-- /.demo-one__image -->
                                <div class="demo-one__content">
                                    <?php if (!empty($item['heading'])) : ?>
                                        <h3 class="demo-one__title">
                                            <a href="<?php echo esc_url($item['multi_page_url']['url']); ?>" <?php esc_attr(!empty($item['multi_page_url']['is_external']) ? "target=_blank" : ' '); ?>><?php echo esc_html($item['heading']); ?></a>
                                        </h3><!-- /.demo-one__title -->
                                    <?php endif; ?>
                                </div><!-- /.demo-one__content -->
                            </div><!-- /.demo-one__card -->
                        </div><!-- /.col-md-6 col-lg-3 -->
                    <?php endforeach; ?>
                </div><!-- /.row -->

            </div><!-- /.home-showcase__inner -->
        </div><!-- /.container -->
    </section>
<?php endif; ?>