<?php
$search_status = $settings['search_enable'];
$cart_status = $settings['cart_enable'];
$sticky_status = (get_theme_mod('header_sticky_menu') == 'yes'  && !is_admin_bar_showing()) ? 'sticky-header' : '';
$sticky_onepage_status = ($settings['onepage_menu'] == 'yes' && !is_admin_bar_showing()) ? 'sticky-header--one-page' : 'sticky-header--normal';

if ('layout_one' === $settings['layout_type']) {
	$sticky_status = (get_theme_mod('header_sticky_menu') == 'yes'  && !is_admin_bar_showing()) ? 'sticky-header--normal' : '';
	$sticky_onepage_status = ($settings['onepage_menu'] == 'yes' && !is_admin_bar_showing()) ? 'sticky-header--one-page' : ' ';
}
if ('layout_two' === $settings['layout_type']) {
	$sticky_status = (get_theme_mod('header_sticky_menu') == 'yes'  && !is_admin_bar_showing()) ? 'sticky-header--normal' : '';
	$sticky_onepage_status = ($settings['onepage_menu'] == 'yes' && !is_admin_bar_showing()) ? 'sticky-header--one-page' : ' ';
}

if ('layout_one' === $settings['layout_type']) : ?>
	<header class="main-header main-header--one sticky-header--one <?php echo esc_attr($sticky_status . " " . $sticky_onepage_status); ?>">
		<div class="container-fluid">
			<div class="main-header__inner">
				<div class="main-header__logo">
					<a href="<?php echo esc_url(home_url('/')); ?>">
						<img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_url($settings['light_logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
					</a>
				</div><!-- /.main-header__logo -->

				<nav class="main-header__nav main-menu">
					<?php
					wp_nav_menu(
						array(
							'menu' => $settings['nav_menu'],
							'menu_class' => 'main-menu__list',
							'walker'         => class_exists('\Layerdrops\Hostom\Megamenu\Walker_Nav_Menu') ? new \Layerdrops\Hostom\Megamenu\Walker_Nav_Menu : '',
						)
					);
					?>
				</nav><!-- /.main-header__nav -->

				<div class="main-header__right">
					<div class="main-header__right__social">
						<?php foreach ($settings['social_icons'] as $social_icon) : ?>
							<a <?php echo esc_attr(!empty($social_icon['social_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($social_icon['social_url']['url']); ?>">
								<?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true'], 'i'); ?>
							</a>
						<?php endforeach; ?>
					</div><!-- /.main-header__right-->
					<?php if (!empty($settings['button_label'])) : ?>
						<a href="<?php echo esc_url($settings['button_url']['url']); ?>" <?php esc_attr(!empty($settings['button_url']['is_external']) ? "target=_blank" : ' '); ?> class="main-header__right__btn hostom-btn">
							<?php echo esc_html($settings['button_label']); ?>
						</a>
					<?php endif; ?>
					<div class="main-header__right__info">
						<?php if (('yes' == $search_status)) : ?>
							<a href="#" class="search-toggler info__item">
								<i class="icon-search" aria-hidden="true"></i>
							</a>
						<?php endif; ?>
						<?php if ('yes' == $cart_status && class_exists('WooCommerce')) : ?>
							<a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="info__item">
								<i class="icon-trolley-cart_4175270" aria-hidden="true"></i>
							</a>
						<?php endif; ?>
					</div>

					<div class="mobile-nav__btn mobile-nav__toggler">
						<span></span>
						<span></span>
						<span></span>
					</div>
					<div class="main-header__right__arrow">
						<?php hostom_elementor_rendered_image($settings, 'shape'); ?>
					</div><!-- /.main-header__arrow -->
				</div>
			</div>
		</div>
	</header>
<?php endif; ?>

<?php if ('layout_two' === $settings['layout_type']) : ?>
	<div class="topbar-one">
		<div class="container">
			<div class="topbar-one__inner">
				<ul class="list-unstyled topbar-one__info ml-0">
					<?php foreach ($settings['topbar_infos'] as $info) : ?>
						<li class="topbar-one__info__item">
							<?php \Elementor\Icons_Manager::render_icon($info['topbar_icon'], ['aria-hidden' => 'true', 'class' => 'topbar-one__info__icon'], 'i'); ?>
							<?php echo wp_kses($info['topbar_info_text'], 'hostom_allowed_tags'); ?>
						</li>
					<?php endforeach; ?>
				</ul><!-- /.list-unstyled topbar-one__info -->
				<div class="topbar-one__right">
					<div class="topbar-one__social">
						<?php foreach ($settings['social_icons'] as $social_icon) : ?>
							<a href="<?php echo esc_url($social_icon['social_url']['url']); ?>">
								<?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true'], 'i'); ?>
							</a>
						<?php endforeach; ?>
					</div><!-- /.topbar-one__social -->
				</div><!-- /.topbar-one__right -->
			</div><!-- /.topbar-one__inner -->
		</div><!-- /.container-fluid -->
	</div><!-- /.topbar-one -->
	<header class="main-header main-header--two sticky-header--two <?php echo esc_attr($sticky_status . " " . $sticky_onepage_status); ?>">
		<div class="container">
			<div class="main-header__inner">
				<div class="main-header__logo">
					<a href="<?php echo esc_url(home_url('/')); ?>">
						<img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_url($settings['light_logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
					</a>
				</div><!-- /.main-header__logo -->

				<nav class="main-header__nav main-menu">
					<?php
					wp_nav_menu(
						array(
							'menu' => $settings['nav_menu'],
							'menu_class' => 'main-menu__list',
							'walker'         => class_exists('\Layerdrops\Hostom\Megamenu\Walker_Nav_Menu') ? new \Layerdrops\Hostom\Megamenu\Walker_Nav_Menu : '',
						)
					);
					?>
				</nav><!-- /.main-header__nav -->
				<div class="main-header__right">
					<?php if (('yes' == $search_status)) : ?>
						<a href="#" class="search-toggler main-header__search">
							<i class="icon-magnifying-glass" aria-hidden="true"></i>
						</a><!-- /.search-toggler -->
					<?php endif; ?>
					<?php if ('yes' == $cart_status && class_exists('WooCommerce')) : ?>
						<a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="main-header__cart">
							<i class="icon-shopping-cart" aria-hidden="true"></i>
						</a><!-- /.search-toggler -->
					<?php endif; ?>
					<?php if (!empty($settings['button_label'])) : ?>
						<a href="<?php echo esc_url($settings['button_url']['url']); ?>" <?php esc_attr(!empty($settings['button_url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn main-header__btn"><?php echo esc_html($settings['button_label']); ?></a><!-- /.thm-btn main-header__btn -->
					<?php endif; ?>
					<div class="mobile-nav__btn mobile-nav__toggler">
						<span></span>
						<span></span>
						<span></span>
					</div><!-- /.mobile-nav__toggler -->
				</div><!-- /.main-header__right -->
			</div><!-- /.main-header__inner -->
		</div><!-- /.container-fluid -->
	</header><!-- /.main-header -->
<?php endif; ?>

<?php if ('layout_three' === $settings['layout_type']) : ?>
	<header class="main-header main-header--three <?php echo esc_attr($sticky_status . " " . $sticky_onepage_status); ?>">
		<div class="container-fluid">
			<div class="main-header__inner">
				<div class="main-header__logo">
					<a href="<?php echo esc_url(home_url('/')); ?>">
						<img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_url($settings['light_logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
					</a>
				</div><!-- /.main-header__logo -->

				<nav class="main-header__nav main-menu">
					<?php
					wp_nav_menu(
						array(
							'menu' => $settings['nav_menu'],
							'menu_class' => 'main-menu__list',
							'walker'         => class_exists('\Layerdrops\Hostom\Megamenu\Walker_Nav_Menu') ? new \Layerdrops\Hostom\Megamenu\Walker_Nav_Menu : '',
						)
					);
					?>
				</nav><!-- /.main-header__nav -->

				<div class="main-header__right">
					<div class="main-header__right__inner">
						<a href="<?php echo esc_url($settings['call_url']); ?>" class="info__item__call">
							<div class="info__item__icon">
								<?php \Elementor\Icons_Manager::render_icon($settings['call_icon'], ['aria-hidden' => 'true'], 'i'); ?>
							</div>
							<div class="info__item__content">
								<span class="info__item__content__text"><?php echo wp_kses($settings['call_text'], 'hostom_allowed_tags'); ?></span>
								<h6 class="info__item__content__call"><?php echo wp_kses($settings['call_number'], 'hostom_allowed_tags'); ?></h6>
							</div>
						</a>
						<div class="main-header__right__social">
							<?php foreach ($settings['social_icons'] as $social_icon) : ?>
								<a <?php echo esc_attr(!empty($social_icon['social_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($social_icon['social_url']['url']); ?>">
									<?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true'], 'i'); ?>
								</a>
							<?php endforeach; ?>
						</div><!-- /.main-header__right-->
						<div class="main-header__right__info">
							<?php if (('yes' == $search_status)) : ?>
								<a href="#" class="search-toggler info__item">
									<i class="icon-search" aria-hidden="true"></i>
								</a>
							<?php endif; ?>
							<?php if ('yes' == $cart_status && class_exists('WooCommerce')) : ?>
								<a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="info__item">
									<i class="icon-trolley-cart_4175270" aria-hidden="true"></i>
								</a>
							<?php endif; ?>
						</div>
					</div><!-- /.main-header__right__item -->
					<div class="mobile-nav__btn mobile-nav__toggler">
						<span></span>
						<span></span>
						<span></span>
					</div><!-- /.mobile-nav__toggler -->
				</div><!-- /.main-header__right -->
			</div><!-- /.main-header__inner -->
		</div><!-- /.container-fluid -->
	</header><!-- /.main-header -->
<?php endif; ?>

<?php if ('layout_four' === $settings['layout_type']) : ?>
	<header class="main-header main-header--fore <?php echo esc_attr($sticky_status . " " . $sticky_onepage_status); ?>">
		<div class="container-fluid">
			<div class="main-header__inner">
				<div class="main-header__logo">
					<a href="<?php echo esc_url(home_url('/')); ?>">
						<img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_url($settings['light_logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
					</a>
				</div><!-- /.main-header__logo -->

				<nav class="main-header__nav main-menu">
					<?php
					wp_nav_menu(
						array(
							'menu' => $settings['nav_menu'],
							'menu_class' => 'main-menu__list',
							'walker'         => class_exists('\Layerdrops\Hostom\Megamenu\Walker_Nav_Menu') ? new \Layerdrops\Hostom\Megamenu\Walker_Nav_Menu : '',
						)
					);
					?>
				</nav><!-- /.main-header__nav -->

				<div class="main-header__right">
					<div class="main-header__right__inner">
						<a href="<?php echo esc_url($settings['call_url']); ?>" class="info__item__call">
							<div class="info__item__icon">
								<?php \Elementor\Icons_Manager::render_icon($settings['call_icon'], ['aria-hidden' => 'true'], 'i'); ?>
							</div>
							<div class="info__item__content">
								<span class="info__item__content__text"><?php echo wp_kses($settings['call_text'], 'hostom_allowed_tags'); ?></span>
								<h6 class="info__item__content__call"><?php echo wp_kses($settings['call_number'], 'hostom_allowed_tags'); ?></h6>
							</div>
						</a>
						<div class="main-header__right__social">
							<?php foreach ($settings['social_icons'] as $social_icon) : ?>
								<a <?php echo esc_attr(!empty($social_icon['social_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($social_icon['social_url']['url']); ?>">
									<?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true'], 'i'); ?>
								</a>
							<?php endforeach; ?>
						</div><!-- /.main-header__right-->
						<div class="main-header__right__info">
							<?php if (('yes' == $search_status)) : ?>
								<a href="#" class="search-toggler info__item">
									<i class="icon-search" aria-hidden="true"></i>
								</a>
							<?php endif; ?>
							<?php if ('yes' == $cart_status && class_exists('WooCommerce')) : ?>
								<a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="info__item">
									<i class="icon-trolley-cart_4175270" aria-hidden="true"></i>
								</a>
							<?php endif; ?>
						</div>
					</div><!-- /.main-header__right__item -->
					<div class="mobile-nav__btn mobile-nav__toggler">
						<span></span>
						<span></span>
						<span></span>
					</div><!-- /.mobile-nav__toggler -->
				</div><!-- /.main-header__right -->
			</div><!-- /.main-header__inner -->
		</div><!-- /.container-fluid -->
	</header><!-- /.main-header -->
<?php endif; ?>

<?php if ('layout_five' === $settings['layout_type']) : ?>
	<header class="main-header--six <?php echo esc_attr($sticky_status . " " . $sticky_onepage_status); ?>">
		<div class="container-fluid">
			<div class="main-header__inner">
				<div class="main-header__logo">
					<a href="<?php echo esc_url(home_url('/')); ?>">
						<img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_url($settings['light_logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
					</a>
				</div><!-- /.main-header__logo -->

				<nav class="main-header__nav main-menu">
					<?php
					wp_nav_menu(
						array(
							'menu' => $settings['nav_menu'],
							'menu_class' => 'main-menu__list',
							'walker'         => class_exists('\Layerdrops\Hostom\Megamenu\Walker_Nav_Menu') ? new \Layerdrops\Hostom\Megamenu\Walker_Nav_Menu : '',
						)
					);
					?>
				</nav><!-- /.main-header__nav -->

				<div class="main-header__right">
					<?php if (!empty($settings['button_label'])) : ?>
						<a href="<?php echo esc_url($settings['button_url']['url']); ?>" <?php esc_attr(!empty($settings['button_url']['is_external']) ? "target=_blank" : ' '); ?> class="main-header__contact__btn hostom-btn">
							<?php echo esc_html($settings['button_label']); ?>
						</a>
					<?php endif; ?>
					<div class="main-header__right__social">
						<?php foreach ($settings['social_icons'] as $social_icon) : ?>
							<a <?php echo esc_attr(!empty($social_icon['social_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($social_icon['social_url']['url']); ?>">
								<?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true'], 'i'); ?>
							</a>
						<?php endforeach; ?>
					</div><!-- /.main-header__right-->

					<div class="main-header__right__info">
						<?php if (('yes' == $search_status)) : ?>
							<a href="#" class="search-toggler info__item">
								<i class="icon-search" aria-hidden="true"></i>
							</a>
						<?php endif; ?>
						<?php if ('yes' == $cart_status && class_exists('WooCommerce')) : ?>
							<a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="info__item">
								<i class="icon-trolley-cart_4175270" aria-hidden="true"></i>
							</a>
						<?php endif; ?>
					</div>

					<div class="mobile-nav__btn mobile-nav__toggler">
						<span></span>
						<span></span>
						<span></span>
					</div>
				</div>
			</div>
		</div>
	</header>
<?php endif; ?>

<div class="mobile-nav__wrapper">
	<div class="mobile-nav__overlay mobile-nav__toggler"></div>
	<!-- /.mobile-nav__overlay -->
	<div class="mobile-nav__content">
		<span class="mobile-nav__close mobile-nav__toggler"><i class="fa fa-times"></i></span>

		<div class="logo-box logo-retina">
			<a href="<?php echo esc_url(home_url('/')); ?>" aria-label="logo image">
				<img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_attr($settings['mobile_menu_logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>" />
			</a>
		</div>
		<!-- /.logo-box -->
		<div class="mobile-nav__container"></div>
		<!-- /.mobile-nav__container -->
		<ul class="mobile-nav__contact list-unstyled ml-0">
			<?php if ($settings['mobile_email']) : ?>
				<li>
					<i class="fa fa-envelope"></i>
					<a href="mailto:<?php echo esc_attr($settings['mobile_email']); ?>"><?php echo esc_html($settings['mobile_email']); ?></a>
				</li>
			<?php endif; ?>
			<?php if ($settings['mobile_phone']) : ?>
				<li>
					<i class="fa fa-phone-alt"></i>
					<a href="tel:<?php echo esc_url(str_replace(' ', '-', $settings['mobile_phone'])); ?>">
						<?php echo esc_html($settings['mobile_phone']); ?>
					</a>
				</li>
			<?php endif; ?>
		</ul><!-- /.mobile-nav__contact -->
		<div class="mobile-nav__top">
			<div class="mobile-nav__social">
				<?php foreach ($settings['mobile_menu_social_icons'] as $social_icon) : ?>
					<a href="<?php echo esc_url($social_icon['social_url']['url']); ?>" class="fab <?php echo esc_attr($social_icon['social_icon']); ?>"></a>
				<?php endforeach; ?>
			</div><!-- /.mobile-nav__social -->
		</div><!-- /.mobile-nav__top -->

	</div>
	<!-- /.mobile-nav__content -->
</div>

<div class="search-popup">
	<div class="search-popup__overlay search-toggler"></div>
	<!-- /.search-popup__overlay -->
	<div class="search-popup__content">
		<form role="search" method="get" class="search-popup__form" action="<?php echo esc_url(home_url('/')); ?>">
			<input type="text" name="s" id="search" placeholder="<?php echo esc_html__("Search Here...", 'hostom-addon'); ?>">
			<button type="submit" aria-label="search submit" class="hostom-btn hostom-btn--base">
				<span><i class="icon-search"></i></span>
			</button>
		</form>
	</div>
	<!-- /.search-popup__content -->
</div>
<!-- /.search-popup -->


<?php $hostom_back_to_top_status = get_theme_mod('scroll_to_top', 'no'); ?>
<?php if ('yes' === $hostom_back_to_top_status) : ?>
	<!-- back-to-top-start -->
	<a href="#" data-target="html" class="scroll-to-target scroll-to-top">
		<span class="scroll-to-top__text"><?php echo esc_html(get_theme_mod("scroll_to_top_text", false)); ?></span>
		<span class="scroll-to-top__wrapper"><span class="scroll-to-top__inner"></span></span>
	</a>
<?php endif; ?>