<?php if ('layout_two' == $settings['layout_type']) : ?>

    <section class="gallery-one gallery-one--page">
        <div class="container">
            <div class="text-center">
                <ul class="list-unstyled post-filter gallery-one__filter__list">
                    <li class="active" data-filter=".filter-item"><span class="hostom-btn"><?php esc_html_e('All', 'hostom-addon'); ?></span></li>
                    <?php foreach ($settings['layout_two_projects_filter'] as $item) : ?>
                        <li data-filter=".<?php echo esc_attr($item['slug']); ?>"><span class="hostom-btn"><?php echo esc_html($item['name']); ?></span></li>
                    <?php endforeach; ?>
                </ul><!-- /.list-unstyledf -->
            </div><!-- /.text-center -->
            <div class="row masonry-layout filter-layout">
                <?php
                $i = 1;
                $class = 'col-lg-4';
                foreach ($settings['gallery_list_two'] as $index => $item) :
                    if ($i == 7) {
                        $class = 'col-lg-8';
                    }
                ?>
                    <div class="col-md-6 <?php echo esc_attr($class); ?> filter-item <?php echo esc_attr($item['slug']); ?>">
                        <div class="gallery-one__card">
                            <?php hostom_elementor_rendered_image($item, 'image'); ?>
                            <div class="gallery-one__card__hover">
                                <a href="<?php echo esc_url($item['image']['url']); ?>" class="img-popup">
                                    <span class="gallery-one__card__icon"></span>
                                </a>
                            </div><!-- /.gallery-one__card__hover -->
                        </div><!-- /.gallery-one__card -->
                    </div><!-- /.col-md-6 col-lg-4 -->
                <?php
                    $i++;
                endforeach; ?>
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </section><!-- /.gallery-one -->

<?php endif; ?>