<?php if ('layout_four' == $settings['layout_type']) : ?>

    <!--Gallery Four Page Start-->
    <section class="gallery-one gallery-one--page">
        <div class="container-fluid">
            <?php if ('yes' == $settings['layout_four_enable_filter']) : ?>
                <div class="text-center">
                    <ul class="list-unstyled post-filter gallery-one__filter__list">
                        <li class="active" data-filter=".filter-item"><span><?php esc_html_e('All', 'hostom-addon'); ?></span></li>
                        <?php foreach ($settings['layout_four_projects_filter'] as $item) : ?>
                            <li data-filter=".<?php echo esc_attr($item['slug']); ?>"><span><?php echo esc_html($item['name']); ?></span></li>
                        <?php endforeach; ?>
                    </ul><!-- /.list-unstyledf -->
                </div><!-- /.text-center -->
            <?php endif; ?>
            <div class="row masonry-layout filter-layout">
                <?php foreach ($settings['gallery_list_four'] as $index => $item) :
                    $image_name = $item['image']['url'];
                    list($width, $height) = getimagesize($image_name);
                ?>
                    <div class="col-md-6 col-lg-<?php if ($width >= '750') : echo esc_attr("6");
                                                else : echo ("3");
                                                endif; ?> filter-item <?php echo esc_attr($item['slug']); ?>">
                        <div class="gallery-one__card">
                            <?php hostom_elementor_rendered_image($item, 'image'); ?>
                            <div class="gallery-one__card__hover">
                                <a href="<?php echo esc_url($item['image']['url']); ?>" class="img-popup">
                                    <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'span'); ?>
                                </a>
                            </div><!-- /.gallery-one__card__hover -->
                        </div><!-- /.gallery-one__card -->
                    </div><!-- /.col-md-6 col-lg-4 -->
                <?php endforeach; ?>
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </section><!-- /.gallery-one -->
    <!--Gallery Four Page End-->

<?php endif; ?>