<?php if ('layout_one' == $settings['layout_type']) : ?>
    <div class="main-footer__top">
        <div class="container">
            <div class="main-footer__inner">
                <a href="<?php echo esc_url(home_url('/')); ?>" class="main-footer__inner-logo">
                    <img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_url($settings['light_logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
                </a>
                <div class="main-footer__inner-social">
                    <?php foreach ($settings['social_icons'] as $social_icon) : ?>
                        <a <?php echo esc_attr(!empty($social_icon['social_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($social_icon['social_url']['url']); ?>">
                            <?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true'], 'i'); ?>
                        </a>
                    <?php endforeach; ?>
                </div><!-- /.footer-widget__social -->
            </div>
        </div><!-- /.container -->
    </div><!-- /.main-footer__top -->
<?php endif; ?>