<?php if ('layout_two' == $settings['layout_type']) : ?>
    <div class="footer-widget--info footer-widget__info__three">
        <a href="<?php echo esc_url(home_url('/')); ?>" class="footer-widget__logo">
            <img width="<?php echo esc_attr($settings['layout_two_logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['layout_two_logo_dimension']['height']); ?>" src="<?php echo esc_url($settings['layout_two_light_logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
        </a><!-- /.footer-widget__logo -->
        <p class="footer-widget__text"><?php echo wp_kses($settings['layout_two_text'], 'hostom_allowed_tags'); ?></p><!-- /.footer-widget__text -->
        <div class="footer-widget__social">
            <?php foreach ($settings['layout_two_social_icons'] as $social_icon) : ?>
                <a href="<?php echo esc_url($social_icon['social_url']['url']); ?>" <?php echo esc_attr(!empty($social_icon['social_url']['is_external']) ? 'target=_blank' : ' '); ?>>
                    <?php \Elementor\Icons_Manager::render_icon($social_icon['social_icon'], ['aria-hidden' => 'true'], 'i'); ?>
                </a>
            <?php endforeach; ?>
        </div>
    </div><!-- /.footer-widget -->
<?php endif; ?>