<?php if ('layout_one' == $settings['layout_type']) : ?>
	<section class="control-box-one">
		<div class="container">
			<div class="row">
				<?php $i = 1;
				foreach ($settings['features_list'] as $index => $item) : ?>
					<div class="col-lg-6">
						<div class="control-box-one__item wow fadeInUp" data-wow-duration="1000ms" data-wow-delay="500ms">
							<div class="control-box-one__item__icon">
								<?php hostom_elementor_rendered_image($item, 'image'); ?>
							</div><!-- /.control-box-one__item__icon -->
							<<?php echo esc_attr($item['title_tag_layout_one']); ?> class="control-box-one__item__title">
								<a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?>><?php echo wp_kses($item['title'], 'hostom_allowed_tags'); ?></a>
							</<?php echo esc_attr($item['title_tag_layout_one']); ?>><!-- /.control-box-one__item__title -->
							<p class="control-box-one__item__text"><?php echo wp_kses($item['content'], 'hostom_allowed_tags'); ?> </p><!-- /.control-box-one__item__title -->
							<div class="control-box-one__item__btn">
								<a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn"><?php echo esc_html($item['btn_label']); ?></a>
							</div><!-- /.control-box-one__item__btn -->
							<div class="control-box-one__element">
								<?php hostom_elementor_rendered_image($item, 'shape'); ?>
							</div><!-- /.control-box-one__element -->
						</div><!-- /.control-box-one__item -->
					</div><!-- /.col-lg-6 -->
				<?php $i++;
				endforeach; ?>
			</div><!-- /.row -->
		</div><!-- /.container -->
	</section><!-- /.control-box-one -->
<?php endif; ?>