<?php if ('layout_one' === $settings['layout_type']) : ?>
    <section class="error-404">
        <div class="container">
            <div class="error-404__thumb wow fadeInUp" data-wow-duration="1500ms">
                <div class="error-404__thumb__item error-404__thumb__item--one">
                    <?php hostom_elementor_rendered_image($settings, 'shape_one'); ?>
                </div>
                <div class="error-404__thumb__item error-404__thumb__item--two">
                    <?php hostom_elementor_rendered_image($settings, 'shape_two'); ?>
                </div>
                <div class="error-404__thumb__item error-404__thumb__item--three">
                    <?php hostom_elementor_rendered_image($settings, 'shape_three'); ?>
                </div>
                <div class="error-404__thumb__item error-404__thumb__item--fore">
                    <?php hostom_elementor_rendered_image($settings, 'shape_four'); ?>
                </div>
                <div class="error-404__thumb__item error-404__thumb__item--five">
                    <?php hostom_elementor_rendered_image($settings, 'shape_five'); ?>
                </div>
            </div><!-- /.error-404__title -->
            <h3 class="error-404__sub-title  wow fadeInUp" data-wow-duration="1500ms"><?php echo esc_html($settings['title']); ?></h3><!-- /.error-404__title -->
            <p class="error-404__text  wow fadeInUp" data-wow-duration="1500ms"><?php echo esc_html($settings['sub_title']); ?></p><!-- /.error-404__text -->
            <form action="<?php echo esc_url(home_url('/')); ?>" class="error-404__search">
                <input type="text" id="error-search" name="s" placeholder="<?php echo esc_attr($settings['search_place_holder']); ?>">
                <button type="submit" class="error-404__search__btn" aria-label="search submit">
                    <span><i class="icon-search"></i></span>
                </button>
            </form><!-- /.error-404__search -->
            <div class="error-404__btns">
                <a href="<?php echo esc_url($settings['button_url']['url']); ?>" <?php esc_attr(!empty($settings['button_url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn hostom-btn--secondary"><span><?php echo esc_html($settings['button_label']); ?></span></a>
            </div><!-- /.error-404__btns -->
        </div><!-- /.container -->
    </section><!-- /.error-404 -->
<?php endif; ?>