<?php if ('layout_two' === $settings['layout_type']) : ?>
    <!-- domain-name section start -->
    <section class="domain-name domain-name--two wow fadeInUp" data-wow-duration='1000ms' data-wow-delay='500ms'>
        <div class="container">
            <div class="domain-name__inner domain-name__inner--two">
                <div class="domain-name__inner__bg" style="background-image: url(<?php echo esc_url($settings['layout_two_bg_shape']['url']); ?>);"></div>
                <div class="domain-name__form">
                    <form class="domain-name__form__item">
                        <input type="text" name="domain" placeholder="<?php echo esc_attr($settings['layout_two_domain_placeholder']); ?>">
                        <button type="submit" class="hostom-btn"><i class="icon-search"></i></button>
                    </form>
                    <div class="domain-result"></div>
                    <div class="domain-form__response"></div>
                </div>
                <ul class="list-unstyled domain-name__list ml-0">
                    <?php foreach ($settings['layout_two_domain_info'] as $item) : ?>
                        <li class="domain-name__list__item"><span><?php echo esc_html($item['tlds']); ?></span><?php echo esc_html($item['price']); ?></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
    </section>
    <!-- domain-name section end -->
    <form action="<?php echo esc_url($settings['whmcs_url']); ?>/cart.php?a=add&domain=register" class="domain-form hostom" method="post" target="_blank">
        <input type="text" name="query" class="query" size="20" />
    </form>

    <script>
        jQuery(document).ready(function($) {
            $('.domain-name__form').on('submit', function(event) {
                event.preventDefault();
                var domain = $(this).find('input[name="domain"]').val();
                $.ajax({
                    type: 'GET',
                    url: hostom_login_object.ajaxurl, // WordPress AJAX URL
                    data: {
                        action: 'hostom_check_domain_availability',
                        domain: domain
                    },
                    beforeSend: function() {
                        // setting a timeout
                        $(".domain-result").addClass("loading");
                        $(".domain-form__response").empty("").removeClass('alert');
                    },
                    success: function(response) {
                        $(".domain-result").removeClass("loading");
                        if (domain.trim() === '') {
                            $('.domain-form__response').addClass("alert alert-warning").text('<?php echo esc_attr($settings['if_domain_empty']); ?>');
                            return;
                        }
                        var validTLDs = [<?php echo $settings['available_tld']; ?>]; // List of valid TLDs
                        var domainParts = domain.split('.');
                        var tld = domainParts[domainParts.length - 1].toLowerCase();
                        if (!validTLDs.includes(tld)) {
                            $('.domain-form__response').addClass("alert alert-warning").text('<?php echo esc_attr($settings['if_domain_empty']); ?>');
                            return;
                        }

                        if (response.available) {
                            $('.domain-form__response').removeClass("alert alert-warning").addClass("alert alert-success").html(domain + ' <?php echo esc_attr($settings['if_domain_available']); ?> <a class="hostom-btn hostom-btn--secondary domain-form-button" href="#">Buy Now</a>');
                            $('.query').val(domain)
                        } else {
                            $('.domain-form__response').addClass("alert alert-warning").html(domain + ' <?php echo esc_attr($settings['if_domain_unavailable']); ?>');
                        }
                    }
                });
            });

            $(document).on('click', '.domain-form-button', function(event) {
                event.preventDefault();
                $('.domain-form').submit();
            });


        });
    </script>
<?php endif; ?>