<?php if ('layout_three' === $settings['layout_type']) : ?>
    <!-- domain-name-two section start -->
    <section class="domain-name-two">
        <div class="container">
            <div class="row align-items-end">
                <div class="col-lg-6">
                    <div class="domain-name-two__left">
                        <div class="domain-name-two__inner">
                            <div class="domain-name-two__form">
                                <form class="domain-name-two__form__item">
                                    <input type="text" name="domain" placeholder="<?php echo esc_attr($settings['layout_three_domain_placeholder']); ?>">
                                    <button type="submit" class="hostom-btn"><?php echo esc_html($settings['layout_three_btn_label']); ?></button>
                                </form>
                                <div class="domain-result"></div>
                                <div class="domain-form__response"></div>
                            </div>
                            <ul class="list-unstyled domain-name-two__list ml-0">
                                <?php foreach ($settings['layout_three_domain_info'] as $item) : ?>
                                    <li class="domain-name-two__list__item"><span><?php echo esc_html($item['tlds']); ?></span><?php echo esc_html($item['price']); ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="domain-name-two__right">
                        <ul class="domain-name-two__brand list-unstyled ml-0">
                            <?php
                            foreach ($settings['layout_three_images'] as $index => $item) : ?>
                                <li class="domain-name-two__brand__item">
                                    <?php hostom_elementor_rendered_image($item, 'image'); ?>
                                    <p class="domain-name-two__brand__item__rating"><?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?> <?php echo esc_html($item['rating']); ?></p>
                                </li>
                            <?php
                            endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- domain-name-two section end -->
    <form action="<?php echo esc_url($settings['whmcs_url']); ?>/cart.php?a=add&domain=register" class="domain-form hostom" method="post" target="_blank">
        <input type="text" name="query" class="query" size="20" />
    </form>
    <script>
        jQuery(document).ready(function($) {
            $('.domain-name-two__form').on('submit', function(event) {
                event.preventDefault();
                var domain = $(this).find('input[name="domain"]').val();
                $.ajax({
                    type: 'GET',
                    url: hostom_login_object.ajaxurl, // WordPress AJAX URL
                    data: {
                        action: 'hostom_check_domain_availability',
                        domain: domain
                    },
                    beforeSend: function() {
                        // setting a timeout
                        $(".domain-result").addClass("loading");
                        $(".domain-form__response").empty("").removeClass('alert');
                    },
                    success: function(response) {
                        $(".domain-result").removeClass("loading");
                        if (domain.trim() === '') {
                            $('.domain-form__response').addClass("alert alert-warning").text('<?php echo esc_attr($settings['if_domain_empty']); ?>');
                            return;
                        }
                        var validTLDs = [<?php echo $settings['available_tld']; ?>]; // List of valid TLDs
                        var domainParts = domain.split('.');
                        var tld = domainParts[domainParts.length - 1].toLowerCase();
                        if (!validTLDs.includes(tld)) {
                            $('.domain-form__response').addClass("alert alert-warning").text('<?php echo esc_attr($settings['if_domain_empty']); ?>');
                            return;
                        }

                        if (response.available) {
                            $('.domain-form__response').removeClass("alert alert-warning").addClass("alert alert-success").html(domain + ' <?php echo esc_attr($settings['if_domain_available']); ?> <a class="hostom-btn hostom-btn--secondary domain-form-button" href="#">Buy Now</a>');
                            $('.query').val(domain)
                        } else {
                            $('.domain-form__response').addClass("alert alert-warning").html(domain + ' <?php echo esc_attr($settings['if_domain_unavailable']); ?>');
                        }
                    }
                });
            });

            $(document).on('click', '.domain-form-button', function(event) {
                event.preventDefault();
                $('.domain-form').submit();
            });

        });
    </script>
<?php endif; ?>