<?php if ('layout_two' == $settings['layout_type']) : ?>
    <!-- Call To Action Start -->
    <section class="fact-two">
        <div class="fact-two__bg" style="background-image: url(<?php echo esc_url($settings['layout_two_bg_image']['url']); ?>);"></div>
        <div class="container">
            <div class="row">
                <div class="col-lg-5">
                    <div class="section-title">
                        <div class="section-title__triangle">
                            <span class="section-title__triangle-left"></span>
                            <span class="section-title__triangle-right"></span>
                        </div>
                        <?php
                        if (!empty($settings['layout_two_sec_sub_title'])) :
                            $this->add_inline_editing_attributes('layout_two_sec_sub_title', 'none');
                            hostom_elementor_rendered_content($this, 'layout_two_sec_sub_title', 'section-title__tagline', $settings['section_sub_title_tag_layout_two']);
                        endif;

                        if (!empty($settings['layout_two_sec_title'])) :
                            $this->add_inline_editing_attributes('layout_two_sec_title', 'none');
                            hostom_elementor_rendered_content($this, 'layout_two_sec_title', 'section-title__title', $settings['section_title_tag_layout_two']);
                        endif;
                        ?>
                    </div><!-- section-title -->
                    <div class="fact-two__team">
                        <?php foreach ($settings['layout_two_images'] as $item) : ?>
                            <div class="fact-two__team-item"><img src="<?php echo esc_url($item['url']); ?>" alt="<?php echo esc_attr(hostom_get_thumbnail_alt($item['id'])); ?>" /></div>
                        <?php endforeach; ?>
                        <p class="fact-two__team-text"><?php echo wp_kses($settings['layout_two_image_caption'], 'hostom_allowed_tags'); ?></p>
                    </div>
                </div>
                <div class="col-lg-7 wow fadeInUp animated" data-wow-delay="100ms">
                    <div class="fact-two__wrapper">
                        <?php
                        foreach ($settings['counter_list_two'] as $index => $item) :
                        ?>
                            <div class="fact-two__item text-center">
                                <div class="fact-two__item__icon">
                                    <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'span'); ?>
                                </div><!-- /.fact-two__icon -->
                                <div class="fact-two__item__count">
                                    <span class="count-box">
                                        <span class="count-text" data-stop="<?php echo esc_attr($item['number']); ?>" data-speed="1500"></span>
                                    </span>
                                </div><!-- /.fact-two__count -->
                                <?php
                                if (!empty($item['title'])) :
                                    hostom_basic_rendered_content($this, $item,  'title', 'fact-two__item__title', 'h3');
                                endif;
                                ?>
                            </div><!-- /.fact-two__item -->
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Call To Action End -->
<?php endif; ?>