<?php if ('layout_three' == $settings['layout_type']) : ?>

	<section class="blog-two blog-two--home">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="sec-title text-center wow fadeInUp" data-wow-duration='700ms'>
						<?php
						if (!empty($settings['sec_sub_title'])) :
							$this->add_inline_editing_attributes('sec_sub_title', 'none');
							hostom_elementor_rendered_content($this, 'sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_one']);
						endif;

						if (!empty($settings['sec_title'])) :
							$this->add_inline_editing_attributes('sec_title', 'none');
							hostom_elementor_rendered_content($this, 'sec_title', 'sec-title__title', $settings['section_title_tag_layout_one']);
						endif;
						?>
					</div><!-- /.sec-title -->
				</div><!-- /.col-12 -->
			</div><!-- /.row -->
			<div class="row gutter-y-30">
				<?php
				$blog_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
				if (!empty($settings['select_category'])) :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size'],
						'paged'          => $blog_post_one_query_paged,
						'tax_query' => array(
							array(
								'taxonomy' => 'category',
								'field' => 'slug',
								'terms' => $settings['select_category']
							)
						)
					);
				else :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'paged'          => $blog_post_one_query_paged,
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size']
					);

				endif;
				$blog_post_one_query = new \WP_Query($blog_post_one_query_args);
				$i = 1;

				while ($blog_post_one_query->have_posts()) :
					$blog_post_one_query->the_post();

					$comments_number = get_comments_number();
					$user = wp_get_current_user();
					$author_id = get_the_author_meta('ID');
					$author_img = get_avatar_url($author_id, array("size" => 31));
				?>
					<div class="col-md-6 col-lg-4">
						<div class="blog-card__fore wow fadeInUp" data-wow-delay='300ms'>
							<div class="blog-card__fore__image">
								<a href="<?php the_permalink(); ?>" class="blog-card__fore__image__item">
									<?php the_post_thumbnail('hostom_blog_370X266'); ?>
								</a>
							</div><!-- /.blog-card__fore__image -->
							<div class="blog-card__fore__content">
								<div class="blog-card__fore__date"><span class="blog-card__fore__date__day"><?php the_time('d'); ?></span><?php the_time('M'); ?></div><!-- /.blog-card__fore__date -->
								<div class="blog-card__fore__meta">
									<a href="<?php the_permalink(); ?>" class="blog-card__fore__meta__comment"><i class="icon-bubble-chat-1"></i>
										<?php
										comments_number(__('No Comments', 'hostom-addon'), __('1 Comment', 'hostom-addon'), __('% Comments', 'hostom-addon'));
										?>
									</a>
								</div><!-- /.list-unstyled blog-card__fore__meta -->
								<h3 class="blog-card__fore__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3><!-- /.blog-card__fore__title -->
								<div class="blog-card__fore__content__btn">
									<a href="<?php the_permalink(); ?>" class="blog-card__fore__content__btn__link"><?php echo esc_html($settings['read_more']); ?><i class="icon-right-arrow"></i></a><!-- /.blog-card__fore__link -->
								</div><!-- /.blog-card__fore__btn -->

							</div><!-- /.blog-card__fore__content -->
						</div><!-- /.blog-card__fore -->
					</div><!-- /.col-md-6 col-lg-4 -->
				<?php $i++;
				endwhile; ?>
				<?php if ('yes' == $settings['pagination_status']) : ?>
					<div class="col-lg-12">
						<div class="blog-pagination portfolio-page__btn-box justify-content-center text-center">
							<?php hostom_custom_query_pagination($blog_post_one_query_paged, $blog_post_one_query->max_num_pages); ?>
						</div><!-- /.blog-post-pagination -->
					</div><!-- /.col-lg-12 -->
				<?php endif; ?>
				<?php wp_reset_postdata(); ?>
			</div><!-- /.row -->
		</div><!-- /.container -->
	</section><!-- /.blog-one blog-one__page -->

<?php endif; ?>