<?php if ('layout_six' == $settings['layout_type']) : ?>
	<section class="blog-one">
		<div class="container">
			<div class="blog-one__carousel hostom-owl__carousel hostom-owl__carousel--with-shadow hostom-owl__carousel--basic-nav owl-carousel owl-theme" data-owl-options='<?php echo esc_attr(hostom_get_owl_options($settings)); ?>'>
				<?php
				$blog_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
				if (!empty($settings['select_category'])) :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size'],
						'paged'          => $blog_post_one_query_paged,
						'tax_query' => array(
							array(
								'taxonomy' => 'category',
								'field' => 'slug',
								'terms' => $settings['select_category']
							)
						)
					);
				else :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'paged'          => $blog_post_one_query_paged,
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size']
					);

				endif;
				$blog_post_one_query = new \WP_Query($blog_post_one_query_args);
				$i = 1;

				while ($blog_post_one_query->have_posts()) :
					$blog_post_one_query->the_post();

					$comments_number = get_comments_number();
					$user = wp_get_current_user();
					$author_id = get_the_author_meta('ID');
					$author_img = get_avatar_url($author_id, array("size" => 35));
				?>
					<div class="item">
						<div class="blog-card wow fadeInUp" data-wow-duration=' 1500ms' data-wow-delay='00ms'>
							<div class="blog-card__image">
								<a href="<?php the_permalink(); ?>" class="blog-card__image__item">
									<?php the_post_thumbnail('hostom_blog_370X200'); ?>
								</a>
								<div class="blog-card__date"><span class="blog-card__date__day"><?php the_time('d'); ?></span><?php the_time('M'); ?></div><!-- /.blog-card__date -->
							</div><!-- /.blog-card__image -->
							<div class="blog-card__content">
								<div class="blog-card__meta">
									<a href="<?php the_permalink(); ?>" class="blog-card__meta__comment"><i class="icon-bubble-chat-1"></i>
										<?php
										comments_number(__('No Comments', 'hostom-addon'), __('1 Comment', 'hostom-addon'), __('% Comments', 'hostom-addon'));
										?>
									</a>
								</div><!-- /.list-unstyled blog-card__meta -->
								<h3 class="blog-card__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3><!-- /.blog-card__title -->
								<div class="blog-card__content__btn">
									<a href="<?php the_permalink(); ?>" class="blog-card__content__btn__link"><?php echo esc_html($settings['read_more']); ?><i class="icon-right-arrow"></i></a><!-- /.blog-card__link -->
								</div><!-- /.blog-card__btn -->

							</div><!-- /.blog-card__content -->
						</div><!-- /.blog-card -->
					</div><!-- /.item -->
				<?php $i++;
				endwhile; ?>
			</div><!-- /.row -->
		</div><!-- /.container -->
	</section><!-- /.blog-one blog-one__page -->
<?php endif; ?>