<?php if ('layout_four' == $settings['layout_type']) : ?>
	<!-- blog-fore section start -->
	<section class="blog-fore">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="sec-title text-center sec-title--two wow fadeInUp" data-wow-duration='700ms'>
						<?php
						if (!empty($settings['sec_sub_title'])) :
							$this->add_inline_editing_attributes('sec_sub_title', 'none');
							hostom_elementor_rendered_content($this, 'sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_one']);
						endif;

						if (!empty($settings['sec_title'])) :
							$this->add_inline_editing_attributes('sec_title', 'none');
							hostom_elementor_rendered_content($this, 'sec_title', 'sec-title__title', $settings['section_title_tag_layout_one']);
						endif;
						?>
					</div><!-- /.sec-title -->
				</div>
			</div>
			<div class="row gutter-y-30">
				<?php
				$blog_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
				if (!empty($settings['select_category'])) :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size'],
						'paged'          => $blog_post_one_query_paged,
						'tax_query' => array(
							array(
								'taxonomy' => 'category',
								'field' => 'slug',
								'terms' => $settings['select_category']
							)
						)
					);
				else :
					$blog_post_one_query_args = array(
						'post_type' => 'post',
						'post_status' => 'publish',
						'ignore_sticky_posts' => true,
						'orderby' => 'date',
						'paged'          => $blog_post_one_query_paged,
						'order'   => $settings['query_order'],
						'posts_per_page' => $settings['post_count']['size']
					);

				endif;
				$blog_post_one_query = new \WP_Query($blog_post_one_query_args);
				$i = 1;

				while ($blog_post_one_query->have_posts()) :
					$blog_post_one_query->the_post();

					$comments_number = get_comments_number();
					$user = wp_get_current_user();
					$author_id = get_the_author_meta('ID');
					$author_img = get_avatar_url($author_id, array("size" => 35));
				?>
					<div class="col-lg-4 col-md-6">
						<div class="blog-card__five  wow fadeInUp" data-wow-duration='1000ms' data-wow-delay='500ms'>
							<div class="blog-card__five__image">
								<a href="<?php the_permalink(); ?>" class="blog-card__five__image__item">
									<?php the_post_thumbnail('hostom_blog_370X205'); ?>
								</a>
								<div class="blog-card__five__date">
									<span class="blog-card__five__date__day"><?php the_time('d'); ?></span>
									<span class="blog-card__five__date__month"><?php the_time('M Y'); ?></span>
								</div>
							</div>

							<div class="blog-card__five__content">
								<a href="<?php the_permalink(); ?>" class="blog-card__five__author">
									<div class="blog-card__five__author__image">
										<img src="<?php echo esc_url($author_img); ?>" alt="<?php the_title(); ?>">
									</div>
									<div class="blog-card__five__author__content">
										<h4 class="blog-card__five__author__title"><?php the_author(); ?></h4>
										<p class="blog-card__five__author__deg"><?php echo get_the_author_meta('user_description', $author_id) ?></p>
									</div>
								</a>

								<h3 class="blog-card__five__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
								<p class="blog-card__five__text"><?php echo wp_kses(hostom_excerpt($settings['post_word_count']['size']), 'hostom_allowed_tags'); ?></p>
								<div class="blog-card__five__content__link">
									<a href="<?php the_permalink(); ?>" class="blog-card__five__comments"> <i class="icon-bubble-chat-1"></i>
										<?php
										comments_number(__('No Comments', 'hostom-addon'), __('1 Comment', 'hostom-addon'), __('% Comments', 'hostom-addon'));
										?>
									</a>
									<div class="blog-card__five__btn">
										<a href="<?php the_permalink(); ?>"><?php echo esc_html($settings['read_more']); ?></a>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php $i++;
				endwhile; ?>
				<?php if ('yes' == $settings['pagination_status']) : ?>
					<div class="col-lg-12">
						<div class="blog-pagination portfolio-page__btn-box justify-content-center text-center">
							<?php hostom_custom_query_pagination($blog_post_one_query_paged, $blog_post_one_query->max_num_pages); ?>
						</div><!-- /.blog-post-pagination -->
					</div><!-- /.col-lg-12 -->
				<?php endif; ?>
				<?php wp_reset_postdata(); ?>
			</div>
		</div>
	</section>
	<!-- blog-fore section end -->
<?php endif; ?>