<?php if ('layout_two' === $settings['layout_type']) : ?>
    <section class="hero-two">
        <div class="hero-two__bg" style="background-image: url(<?php echo esc_url($settings['layout_two_shape']['url']); ?>);"></div><!-- /.hero__two__bg -->
        <div class="container">
            <div class="hero-two__inner">
                <div class="hero-two__content">
                    <<?php echo esc_attr($settings['title_tag_layout_two']); ?> class="hero-two__title wow fadeInUp" data-wow-duration="1000ms" data-wow-delay="500ms">
                        <?php echo wp_kses($settings['layout_two_title'], 'hostom_allowed_tags'); ?>
                    </<?php echo esc_attr($settings['title_tag_layout_two']); ?>><!-- /.hero-two__title -->
                    <?php if (!empty($settings['layout_two_button_label'])) : ?>
                        <div class="hero-two__btn"> <a href="<?php echo esc_url($settings['layout_two_button_url']['url']); ?>" <?php esc_attr(!empty($settings['layout_two_button_url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn "><?php echo wp_kses($settings['layout_two_button_label'], 'hostom_allowed_tags'); ?></a> </div><!-- /.hero-two__btn -->
                    <?php endif; ?>
                </div><!-- /.hero-two__content -->
                <div class="hero-two__thumb">
                    <div class="hero-two__thumb__image">
                        <?php hostom_elementor_rendered_image($settings, 'layout_two_image_one'); ?>
                    </div>
                    <div class="hero-two__thumb__item hero-two__thumb__item--three">
                        <?php hostom_elementor_rendered_image($settings, 'layout_two_image_two'); ?>
                    </div>
                    <div class="hero-two__thumb__item hero-two__thumb__item--fore">
                        <?php hostom_elementor_rendered_image($settings, 'layout_two_image_three'); ?>
                    </div>
                    <div class="hero-two__thumb__item hero-two__thumb__item--one wow fadeInDown">
                        <?php hostom_elementor_rendered_image($settings, 'layout_two_image_four'); ?>
                    </div>
                    <div class="hero-two__thumb__item hero-two__thumb__item--two">
                        <?php hostom_elementor_rendered_image($settings, 'layout_two_image_five'); ?>
                    </div>
                    <div class="hero-two__thumb__item hero-two__thumb__item--five">
                        <?php hostom_elementor_rendered_image($settings, 'layout_two_image_six'); ?>
                    </div>
                </div><!-- /.hero-two__thumb -->

            </div><!-- / -->
        </div><!-- /.container -->
        <div class="hero-two__box"></div>
    </section><!-- /.main-slider-three -->
<?php endif; ?>