<?php if ('layout_three' === $settings['layout_type']) : ?>
    <!-- hero-three section start -->
    <section class="hero-three">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="hero-three__content">
                        <<?php echo esc_attr($settings['title_tag_layout_three']); ?> class="hero-three__title wow fadeInLeft" data-wow-duration='1000ms' data-wow-delay='800ms'>
                            <?php echo wp_kses($settings['layout_three_title'], 'hostom_allowed_tags'); ?>
                        </<?php echo esc_attr($settings['title_tag_layout_three']); ?>>
                        <p class="hero-three__text wow fadeInLeft" data-wow-duration='1300ms' data-wow-delay='800ms'><?php echo wp_kses($settings['layout_three_sub_title'], 'hostom_allowed_tags'); ?></p>
                        <?php if (!empty($settings['layout_three_button_label'])) : ?>
                            <div class="hero-three__btn wow fadeInLeft" data-wow-duration='1500ms' data-wow-delay='800ms'>
                                <a href="<?php echo esc_url($settings['layout_three_button_url']['url']); ?>" <?php esc_attr(!empty($settings['layout_three_button_url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn"><?php echo wp_kses($settings['layout_three_button_label'], 'hostom_allowed_tags'); ?></a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="hero-three__right wow fadeInRight" data-wow-duration='1000ms' data-wow-delay='800ms'>
                        <div class="hero-three__thumb">
                            <?php hostom_elementor_rendered_image($settings, 'layout_three_image'); ?>
                            <div class="hero-three__thumb__massage__item">
                                <?php hostom_elementor_rendered_image($settings, 'layout_three_shape_one'); ?>
                            </div>
                            <div class="hero-three__thumb__massage__item hero-three__thumb__massage__item--two">
                                <?php hostom_elementor_rendered_image($settings, 'layout_three_shape_two'); ?>
                            </div>
                            <div class="hero-three__thumb__setting__item">
                                <?php hostom_elementor_rendered_image($settings, 'layout_three_shape_three'); ?>
                            </div>
                            <div class="hero-three__thumb__setting__item hero-three__thumb__setting__item--two">
                                <?php hostom_elementor_rendered_image($settings, 'layout_three_shape_four'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="hero-three__shape wow fadeInLeft" data-wow-duration='1000ms' data-wow-delay='1200ms'>
            <?php hostom_elementor_rendered_image($settings, 'layout_three_shape_five'); ?>
        </div>
    </section>
    <!-- hero-three section end -->
<?php endif; ?>