<?php if ('layout_one' === $settings['layout_type']) : ?>
    <!-- main-slider-start -->
    <section class="hero-one">
        <div class="container">
            <div class="row align-items-end">
                <div class="col-lg-6">
                    <div class="hero-one__content">
                        <<?php echo esc_attr($settings['sub_title_tag_layout_one']); ?> class="hero-one__subtitle wow fadeInLeft" data-wow-duration="1200ms" data-wow-delay="500ms">
                            <?php echo wp_kses($settings['layout_one_sub_title'], 'hostom_allowed_tags'); ?>
                        </<?php echo esc_attr($settings['sub_title_tag_layout_one']); ?>><!-- /.hero-one__dubtitle -->
                        <<?php echo esc_attr($settings['title_tag_layout_one']); ?> class="hero-one__title wow fadeInLeft" data-wow-duration="1400ms" data-wow-delay="500ms">
                            <?php echo wp_kses($settings['layout_one_title'], 'hostom_allowed_tags'); ?>
                        </<?php echo esc_attr($settings['title_tag_layout_one']); ?>><!-- /.hero-one__title -->
                        <?php if (!empty($settings['layout_one_button_label'])) : ?>
                            <div class="hero-one__btn wow fadeInLeft" data-wow-duration="1500ms" data-wow-delay="500ms">
                                <a href="<?php echo esc_url($settings['layout_one_button_url']['url']); ?>" <?php esc_attr(!empty($settings['layout_one_button_url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn"><?php echo wp_kses($settings['layout_one_button_label'], 'hostom_allowed_tags'); ?></a>
                            </div><!-- /.hero-one__btn -->
                        <?php endif; ?>
                    </div><!-- /.hero-one__left -->
                </div><!-- /.col-lg-5 -->
                <div class="col-lg-6">
                    <div class="hero-one__right wow fadeInRight" data-wow-duration="1200ms" data-wow-delay="500ms">
                        <div class="hero-one__thumb">
                            <?php hostom_elementor_rendered_image($settings, 'layout_one_image_one'); ?>
                        </div><!-- /.hero-one__thumb -->
                        <div class="hero-one__thumb__item wow fadeInUp" data-wow-duration="1200ms" data-wow-delay="500ms">
                            <?php hostom_elementor_rendered_image($settings, 'layout_one_image_two'); ?>
                        </div><!-- /.hero-one__thumb -->
                        <div class="hero-one__thumb__item__two">
                            <?php hostom_elementor_rendered_image($settings, 'layout_one_image_three'); ?>
                        </div><!-- /.hero-one__thumb -->
                    </div><!-- /.hero-one__right -->
                </div><!-- /.col-lg-6 -->
            </div><!-- /.row -->
        </div><!-- /.container -->
        <div class="hero-one__shape">
            <?php hostom_elementor_rendered_image($settings, 'layout_one_shape_one'); ?>
        </div><!-- /.hero-one__shape -->
        <div class="hero-one__shape__two">
            <?php hostom_elementor_rendered_image($settings, 'layout_one_shape_two'); ?>
        </div><!-- /.hero-one__shape -->
        <div class="hero-one__shape__three">
            <?php hostom_elementor_rendered_image($settings, 'layout_one_shape_three'); ?>
        </div><!-- /.hero-one__shape -->
    </section>
    <!-- main-slider-end -->
<?php endif; ?>