<?php if ('layout_two' == $settings['layout_type']) : ?>
	<section class="choose-us-one">
		<div class="choose-us-one__inner">
			<div class="container">
				<div class="row">
					<div class="col-lg-6">
						<div class="choose-us-one__left">
							<div class="choose-us-one__thumb">
								<?php hostom_elementor_rendered_image($settings, 'layout_two_image'); ?>
							</div><!-- /.choose-us-one__card -->
						</div><!-- /.choose-us-one__left -->
					</div><!-- /.col-lg-6 -->
					<div class="col-lg-6">
						<div class="choose-us-one__right">
							<div class="choose-us-one__top">
								<div class="sec-title text-start">
									<?php
									if (!empty($settings['layout_two_sec_sub_title'])) :
										$this->add_inline_editing_attributes('layout_two_sec_sub_title', 'none');
										hostom_elementor_rendered_content($this, 'layout_two_sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_two']);
									endif;

									if (!empty($settings['layout_two_sec_title'])) :
										$this->add_inline_editing_attributes('layout_two_sec_title', 'none');
										hostom_elementor_rendered_content($this, 'layout_two_sec_title', 'sec-title__title', $settings['section_title_tag_layout_two']);
									endif;
									?>
								</div><!-- /.sec-title -->
								<p class="choose-us-one__top__text"><?php echo wp_kses($settings['layout_two_summary'], 'hostom_allowed_tags'); ?></p><!-- /.choose-us-one__top__text -->
							</div><!-- /.choose-us-one__top -->
							<?php if (is_array($settings['layout_two_features_list'])) : ?>
								<div class="choose-us-one__feature">
									<?php
									foreach ($settings['layout_two_features_list'] as $index => $item) : ?>
										<div class="choose-us-one__feature__item">
											<div class="choose-us-one__feature__icon">
												<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?>
											</div><!-- /.choose-us-one__feature__icon -->
											<h4 class="choose-us-one__feature__title">
												<a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?>><?php echo wp_kses($item['title'], 'hostom_allowed_tags'); ?></a>
											</h4><!-- /.choose-us-one__feature__title -->
										</div><!-- /.choose-us-one__feature__item -->
									<?php endforeach; ?>
								</div><!-- /.choose-us-one__feature -->
							<?php endif; ?>
							<?php if (is_array($settings['layout_two_features_list'])) : ?>
								<ul class="choose-us-one__list list-unstyled ml-0">
									<?php
									foreach ($settings['layout_two_check_list'] as $index => $item) : ?>
										<li class="choose-us-one__list__item"><?php echo wp_kses($item['title'], 'hostom_allowed_tags'); ?></li><!-- /.choose-us-one__list__item -->
									<?php endforeach; ?>
								</ul><!-- /.choose-us-one__list -->
							<?php endif; ?>
							<?php if (!empty($settings['layout_two_button_label'])) : ?>
								<div class="choose-us-one__btn">
									<a href="<?php echo esc_url($settings['layout_two_button_url']['url']); ?>" <?php esc_attr(!empty($settings['layout_two_button_url']['is_external']) ? "target=_blank" : ' '); ?> class="hostom-btn"><?php echo esc_html($settings['layout_two_button_label']); ?></a>
								</div><!-- /.choose-us-one__btn -->
							<?php endif; ?>
						</div><!-- /.choose-us-one__right -->
					</div><!-- /.col-lg-6 -->
				</div><!-- /.row -->
			</div><!-- /.container -->
			<div class="choose-us-one__image wow fadeInLeft" data-wow-duration="1000ms" data-wow-delay="700ms">
				<?php hostom_elementor_rendered_image($settings, 'layout_two_image_two'); ?>
			</div><!-- /.choose-us-one__image -->
		</div><!-- / -->
		<div class="choose-us-one__bottom">
			<div class="container">
				<div class="row">
					<div class="col-lg-7 offset-lg-5">
						<p class="choose-us-one__bottom__text"><?php echo wp_kses($settings['layout_two_bottom_content'], 'hostom_allowed_tags'); ?></p>
					</div><!-- /.col-md-7 offset-md-5 -->
				</div><!-- /.row -->
			</div><!-- /.container -->
		</div><!-- /.choose-us-one__bottom__text -->

		<div class="choose-us-one__shape">
			<?php hostom_elementor_rendered_image($settings, 'layout_two_shape'); ?>
		</div>
	</section><!-- /.choose-us-->
<?php endif; ?>