<?php if ('layout_six' == $settings['layout_type']) : ?>

	<!-- benefits-three section start -->
	<section class="benefits-three">
		<div class="container">
			<div class="row">
				<div class="col-lg-6">
					<div class="benefits-three__left">
						<div class="benefits-three__top">
							<div class="sec-title text-start wow fadeInUp" data-wow-duration='700ms'>
								<?php
								if (!empty($settings['layout_six_sec_sub_title'])) :
									$this->add_inline_editing_attributes('layout_six_sec_sub_title', 'none');
									hostom_elementor_rendered_content($this, 'layout_six_sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_six']);
								endif;

								if (!empty($settings['layout_six_sec_title'])) :
									$this->add_inline_editing_attributes('layout_six_sec_title', 'none');
									hostom_elementor_rendered_content($this, 'layout_six_sec_title', 'sec-title__title', $settings['section_title_tag_layout_six']);
								endif;
								?>
							</div><!-- /.sec-title -->
							<p class="benefits-three__text"><?php echo wp_kses($settings['layout_six_summary'], 'hostom_allowed_tags'); ?></p>
						</div>
						<ul class="benefits-three__list list-unstyled ml-0">
							<?php foreach ($settings['layout_six_feature_list'] as $item) : ?>
								<li class="benefits-three__list__item wow fadeInUp" data-wow-duration='1000ms' data-wow-delay='500ms'>
									<div class="benefits-three__list__icon">
										<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?>
									</div>
									<div class="benefits-three__list__content">
										<h4 class="benefits-three__list__title">
											<a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?>><?php echo wp_kses($item['title'], 'hostom_allowed_tags'); ?></a>
										</h4>
										<p class="benefits-three__list__text"><?php echo wp_kses($item['content'], 'hostom_allowed_tags'); ?></p>
									</div>
								</li>
							<?php endforeach; ?>
						</ul>
					</div>
				</div>

				<div class="col-lg-6">
					<div class="benefits-three__right wow fadeInRight" data-wow-duration='1000ms' data-wow-delay='500ms'>
						<div class="benefits-three__thumb">
							<?php hostom_elementor_rendered_image($settings, 'layout_six_image'); ?>
						</div>
						<ul class="benefits-three__brand list-unstyled ml-0">
							<?php foreach ($settings['layout_six_images'] as $item) : ?>
								<li class="benefits-three__brand__item">
									<?php hostom_elementor_rendered_image($item, 'image'); ?>
									<p class="benefits-three__brand__item__rating"><i class="icon-star"></i><?php echo esc_html($item['rating']); ?></p>
								</li>
							<?php endforeach; ?>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- benefits-three section start -->
<?php endif; ?>