<?php if ('layout_seven' == $settings['layout_type']) : ?>
	<!-- about-five section start -->
	<section class="about-five">
		<div class="about-five__bg" style="background-image: url(<?php echo esc_url($settings['layout_seven_bg_shape']['url']); ?>);"></div>
		<div class="container">
			<div class="row">
				<div class="col-lg-6">
					<div class="about-five__left">
						<div class="about-five__top">
							<div class="sec-title sec-title--two text-start wow fadeInUp" data-wow-duration='700ms'>
								<?php
								if (!empty($settings['layout_seven_sec_sub_title'])) :
									$this->add_inline_editing_attributes('layout_seven_sec_sub_title', 'none');
									hostom_elementor_rendered_content($this, 'layout_seven_sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_seven']);
								endif;

								if (!empty($settings['layout_seven_sec_title'])) :
									$this->add_inline_editing_attributes('layout_seven_sec_title', 'none');
									hostom_elementor_rendered_content($this, 'layout_seven_sec_title', 'sec-title__title', $settings['section_title_tag_layout_seven']);
								endif;
								?>
							</div><!-- /.sec-title -->
							<p class="about-five__text"><?php echo wp_kses($settings['layout_seven_summary'], 'hostom_allowed_tags'); ?></p>
						</div>
						<?php if (is_array($settings['layout_seven_feature_list'])) : ?>
							<div class="about-five__feature wow fadeInUp" data-wow-duration='1000ms' data-wow-delay='800ms'>
								<?php
								foreach ($settings['layout_seven_feature_list'] as $index => $item) : ?>
									<div class="about-five__feature__item">
										<div class="about-five__feature__icon">
											<div class="about-five__feature__icon__item">
												<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?>
											</div><!-- /.about-five__feature__icon__item -->
											<h5 class="about-five__feature__icon__title"><?php echo wp_kses($item['title'], 'hostom_allowed_tags'); ?></h5><!-- /.about-five__feature__icon__title -->
										</div><!-- /.about-five__feature__icon -->
									</div><!-- /.about-five__feature__item -->
								<?php endforeach; ?>
							</div>
						<?php endif; ?>
						<?php if (is_array($settings['layout_seven_porogressbar_list'])) : ?>
							<div class="about-five__team-skills wow fadeInUp" data-wow-duration='1000ms' data-wow-delay='800ms'>
								<?php
								foreach ($settings['layout_seven_porogressbar_list'] as $index => $item) : ?>
									<div class="about-five__team-skills__progress">
										<h4 class="about-five__team-skills__progress__title"><?php echo esc_html($item['title']); ?></h4>
										<div class="about-five__team-skills__progress__bar">
											<div class="about-five__team-skills__progress__inner count-bar" data-percent="<?php echo esc_attr($item['count']['size']); ?>%">
												<div class="about-five__team-skills__progress__number count-text"><?php echo esc_html($item['count']['size']); ?>%</div>
											</div>
										</div>
									</div><!-- /.skills-item -->
								<?php endforeach; ?>
							</div><!-- /team-skills-one -->
						<?php endif; ?>
					</div>
				</div>
				<div class="col-lg-6">
					<div class="about-five__right wow fadeInRight" data-wow-duration='1000ms' data-wow-delay='800ms'>
						<div class="about-five__thumb">
							<?php hostom_elementor_rendered_image($settings, 'layout_seven_image_one'); ?>
						</div>
						<div class="about-five__thumb about-five__thumb--two">
							<?php hostom_elementor_rendered_image($settings, 'layout_seven_image_two'); ?>
						</div>
						<div class="about-five__box">
							<div class="about-five__box__logo">
								<?php hostom_elementor_rendered_image($settings, 'layout_seven_logo'); ?>
							</div>
						</div>
						<div class="about-five__shape">
							<?php hostom_elementor_rendered_image($settings, 'layout_seven_shape'); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- about-five section end -->
<?php endif; ?>