<?php if ('layout_one' == $settings['layout_type']) : ?>
	<section class="about-three about-three--page">
		<div class="container">
			<div class="row">
				<div class="col-lg-6">
					<div class="about-three__left wow fadeInLeft" data-wow-duration="1000ms" data-wow-delay="500ms">
						<div class="about-three__thumb">
							<div class="about-three__thumb__item">
								<?php hostom_elementor_rendered_image($settings, 'layout_one_image'); ?>
								<div class="about-three__thumb__item__card">
									<a href="<?php echo esc_url($settings['layout_one_call_url']); ?>" class="about-three__thumb__item__card__item">
										<div class="about-three__thumb__item__card__icon">
											<?php \Elementor\Icons_Manager::render_icon($settings['layout_one_call_icon'], ['aria-hidden' => 'true'], 'i'); ?>
										</div><!-- /.about-three__thumb__item__card__icon -->
										<div class="about-three__thumb__item__card__content">
											<span class="about-three__thumb__item__card__subtitle"><?php echo esc_html($settings['layout_one_call_text']); ?></span><!-- /.about-three__thumb__item__card__subtitle -->
											<h6 class="about-three__thumb__item__card__call"><?php echo esc_html($settings['layout_one_call_number']); ?></h6>
										</div><!-- /.about-three__thumb__item__card__content -->
									</a>
								</div><!-- /.about-three__thumb__item__card -->
							</div><!-- /.about-three__thumb__item -->
							<div class="about-three__thumb__item">
								<?php hostom_elementor_rendered_image($settings, 'layout_one_image_two'); ?>
							</div><!-- /.about-three__thumb__item -->
						</div><!-- /.about-three__thumb -->
					</div><!-- /.about-three__left -->
				</div><!-- /.col-lg-6 -->
				<div class="col-lg-6">
					<div class="about-three__right">
						<div class="about-three__top">
							<div class="sec-title text-start wow fadeInUp" data-wow-duration='700ms'>
								<?php
								if (!empty($settings['sec_sub_title'])) :
									$this->add_inline_editing_attributes('sec_sub_title', 'none');
									hostom_elementor_rendered_content($this, 'sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_one']);
								endif;

								if (!empty($settings['sec_title'])) :
									$this->add_inline_editing_attributes('sec_title', 'none');
									hostom_elementor_rendered_content($this, 'sec_title', 'sec-title__title', $settings['section_title_tag_layout_one']);
								endif;
								?>
							</div><!-- /.sec-title -->
							<?php
							if (!empty($settings['summary'])) :
								$this->add_inline_editing_attributes('summary', 'none');
								hostom_elementor_rendered_content($this, 'summary', 'about-three__top__text', 'p');
							endif;
							?>
						</div><!-- /.about-three__top -->
						<div class="about-three__future">
							<ul class="about-three__future__list list-unstyled ml-0">
								<?php
								foreach ($settings['layout_one_images'] as $index => $item) : ?>
									<li class="about-three__future__list__item">
										<?php hostom_elementor_rendered_image($item, 'image'); ?>
										<p class="about-three__future__list__item__rating"><?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?> <?php echo esc_html($item['rating']); ?></p><!-- /.about-three__future__list__item__rating -->
									</li>
								<?php
								endforeach; ?>
							</ul>
						</div><!-- /.about-three__future -->
						<div class="about-three__content">
							<div class="about-three__content__left">
								<div class="about-three__content__box">
									<h3 class="about-three__content__box__title">
										<span><?php echo esc_html($settings['layout_one_domain_info']); ?></span>
										<span><?php echo esc_html($settings['layout_one_domain_name']); ?></span>
									</h3>
									<h5 class="about-three__content__box__price"><?php echo esc_html($settings['layout_one_domain_price']); ?></h5>
								</div><!-- /.about-three__content__box -->
							</div><!-- /.about-three__content__left -->
							<div class="about-three__content__right ml-0">
								<ul class="about-three__content__list list-unstyled ml-0">
									<?php
									foreach ($settings['layout_one_check_list'] as $index => $item) : ?>
										<li class="about-three__content__list__item"><?php echo esc_html($item['title']); ?></li><!-- /.about-three__content__list__item -->
									<?php
									endforeach; ?>
								</ul><!-- /.about-three__content__list -->
								<?php if (!empty($settings['button_label'])) : ?>
									<a href="<?php echo esc_url($settings['button_url']['url']); ?>" <?php esc_attr(!empty($settings['button_url']['is_external']) ? "target=_blank" : ' '); ?> class=" hostom-btn hostom-btn--secondary"><?php echo esc_html($settings['button_label']); ?></a>
								<?php endif; ?>
							</div><!-- /.about-three__content__left -->
						</div><!-- /.about-three__content -->
					</div><!-- /.about-three__right -->
				</div><!-- /.col-lg-6 -->
			</div><!-- /.row -->
		</div><!-- /.container -->
	</section><!-- /.about-three -->
<?php endif; ?>