<?php if ('layout_nine' == $settings['layout_type']) : ?>
	<section class="about-three">
		<div class="container">
			<div class="row">
				<div class="col-lg-6">
					<div class="about-three__left">
						<div class="about-three__thumb">
							<div class="about-three__thumb__item">
								<?php hostom_elementor_rendered_image($settings, 'layout_nine_image_one'); ?>
								<div class="about-three__thumb__item__card">
									<a href="<?php echo esc_url($settings['layout_nine_call_url']); ?>" class="about-three__thumb__item__card__item">
										<div class="about-three__thumb__item__card__icon">
											<?php \Elementor\Icons_Manager::render_icon($settings['layout_nine_call_icon'], ['aria-hidden' => 'true'], 'i'); ?>
										</div><!-- /.about-three__thumb__item__card__icon -->
										<div class="about-three__thumb__item__card__content">
											<span class="about-three__thumb__item__card__subtitle"><?php echo esc_html($settings['layout_nine_call_text']); ?></span><!-- /.about-three__thumb__item__card__subtitle -->
											<h6 class="about-three__thumb__item__card__call"><?php echo esc_html($settings['layout_nine_call_number']); ?></h6>
										</div><!-- /.about-three__thumb__item__card__content -->
									</a>
								</div><!-- /.about-three__thumb__item__card -->
							</div><!-- /.about-three__thumb__item -->
							<div class="about-three__thumb__item">
								<?php hostom_elementor_rendered_image($settings, 'layout_nine_image_two'); ?>
							</div><!-- /.about-three__thumb__item -->
						</div><!-- /.about-three__thumb -->
					</div><!-- /.about-three__left -->
				</div><!-- /.col-lg-6 -->
				<div class="col-lg-6">
					<div class="about-three__right">
						<div class="about-three__top">
							<div class="sec-title text-start wow fadeInUp" data-wow-duration='700ms'>
								<?php
								if (!empty($settings['layout_nine_sec_sub_title'])) :
									$this->add_inline_editing_attributes('layout_nine_sec_sub_title', 'none');
									hostom_elementor_rendered_content($this, 'layout_nine_sec_sub_title', 'sec-title__tagline', $settings['section_sub_title_tag_layout_nine']);
								endif;

								if (!empty($settings['layout_nine_sec_title'])) :
									$this->add_inline_editing_attributes('layout_nine_sec_title', 'none');
									hostom_elementor_rendered_content($this, 'layout_nine_sec_title', 'sec-title__title', $settings['section_title_tag_layout_nine']);
								endif;
								?>
							</div><!-- /.sec-title -->
							<p class="about-three__top__text"><?php echo wp_kses($settings['layout_nine_summary'], 'hostom_allowed_tags'); ?></p><!-- /.about-three__top__text -->
						</div><!-- /.about-three__top -->
						<div class="about-three__future">
							<ul class="about-three__future__list list-unstyled ml-0">
								<?php foreach ($settings['layout_nine_images'] as $item) : ?>
									<li class="about-three__future__list__item">
										<?php hostom_elementor_rendered_image($item, 'image'); ?>
										<p class="about-three__future__list__item__rating"><i class="icon-star"></i> <?php echo esc_html($item['rating']); ?></p><!-- /.about-three__future__list__item__rating -->
									</li>
								<?php endforeach; ?>
							</ul>
						</div><!-- /.about-three__future -->
						<div class="about-three__content">
							<div class="about-three__content__left">
								<div class="about-three__content__box">
									<h3 class="about-three__content__box__title">
										<?php echo wp_kses($settings['layout_nine_domain_info'], 'hostom_allowed_tags'); ?>
									</h3>
									<h5 class="about-three__content__box__price"><?php echo wp_kses($settings['layout_nine_domain_price'], 'hostom_allowed_tags'); ?></h5>
								</div><!-- /.about-three__content__box -->
							</div><!-- /.about-three__content__left -->
							<div class="about-three__content__right">
								<ul class="about-three__content__list list-unstyled ml-0">
									<?php foreach ($settings['layout_nine_check_list'] as $item) : ?>
										<li class="about-three__content__list__item"><?php echo esc_html($item['title']); ?> </li><!-- /.about-three__content__list__item -->
									<?php endforeach; ?>
								</ul><!-- /.about-three__content__list -->
								<?php if (!empty($settings['layout_nine_btn_label'])) : ?>
									<a href="<?php echo esc_url($settings['layout_nine_btn_url']['url']); ?>" <?php esc_attr(!empty($settings['layout_nine_btn_url']['is_external']) ? "target=_blank" : ' '); ?> class=" hostom-btn hostom-btn--secondary"><?php echo esc_html($settings['layout_nine_btn_label']); ?></a>
								<?php endif; ?>
							</div><!-- /.about-three__content__left -->
						</div><!-- /.about-three__content -->
					</div><!-- /.about-three__right -->
				</div><!-- /.col-lg-6 -->
			</div><!-- /.row -->
		</div><!-- /.container -->
	</section><!-- /.about-three -->
<?php endif; ?>