<?php

$this->start_controls_section(
    'layout_two_content_section',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'layout_two_sec_title',
    [
        'label' => __('Section Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Awesome Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Title', 'h3', 'layout_two');

$this->add_control(
    'layout_two_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Awesome Sub Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Sub Title', 'h6', 'layout_two');


$this->add_control(
    'layout_two_sec_summary',
    [
        'label' => __('Section Summary', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Awesome Summary', 'hostom-addon'),
    ]
);


$layout_two_testimonial = new \Elementor\Repeater();

$layout_two_testimonial->add_control(
    'name',
    [
        'label' => __('Name', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Kevin martin', 'hostom-addon'),
        'label_block' => true
    ]
);

hostom_elementor_heading_option($layout_two_testimonial, 'Testimonial Name', 'h5', 'layout_two');

$layout_two_testimonial->add_control(
    'designation',
    [
        'label' => __('Designation', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Customer', 'hostom-addon'),
        'label_block' => true
    ]
);

$layout_two_testimonial->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Default Title', 'hostom-addon'),
        'label_block' => true
    ]
);

$layout_two_testimonial->add_control(
    'testimonial',
    [
        'label' => __('Testimonial', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Testimonial Content', 'hostom-addon'),
    ]
);

$layout_two_testimonial->add_control(
    'rating',
    [
        'label' => __('Rating', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
            'count' => [
                'min' => 1,
                'max' => 5,
                'step' => 1,
            ],
        ],
        'default' => [
            'unit' => 'count',
            'size' => 5,
        ],
    ]
);

$layout_two_testimonial->add_control(
    'image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$layout_two_testimonial->add_control(
    'quite',
    [
        'label' => __('Quite Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);


$this->add_control(
    'layout_two_testimonials',
    [
        'label' => __('Testimonial Items', 'hostom-addon'),
        'prevent_empty' => false,
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_testimonial->get_controls(),
        'title_field' => '{{{ name }}}',
    ]
);


$this->add_control(
    'layout_two_bg',
    [
        'label' => __('Background Image ', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
