<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Title', 'h3', 'layout_one');

$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'hostom-addon'),
        'default' => __('Default Sub Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Sub Title', 'h6', 'layout_one');


$testimonial = new \Elementor\Repeater();

$testimonial->add_control(
    'name',
    [
        'label' => __('Name', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Kevin martin', 'hostom-addon'),
        'label_block' => true
    ]
);

hostom_elementor_heading_option($testimonial, 'Testimonial Name', 'h4', 'layout_one');

$testimonial->add_control(
    'designation',
    [
        'label' => __('Designation', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Customer', 'hostom-addon'),
        'label_block' => true
    ]
);

$testimonial->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Title', 'hostom-addon'),
        'label_block' => true
    ]
);

$testimonial->add_control(
    'testimonial',
    [
        'label' => __('Testimonial', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Testimonial Content', 'hostom-addon'),
    ]
);

$testimonial->add_control(
    'rating',
    [
        'label' => __('Average Rating', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
            'count' => [
                'min' => 1,
                'max' => 5,
                'step' => 1,
            ],
        ],
        'default' => [
            'unit' => 'count',
            'size' => 5,
        ],
    ]
);

$testimonial->add_control(
    'quote_icon',
    [
        'label' => __('Quote Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-quite',
            'library' => 'custom-icon',
        ],
    ]
);

$testimonial->add_control(
    'image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$testimonial->add_control(
    'nav_image',
    [
        'label' => __('Nav Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'testimonials',
    [
        'label' => __('Testimonial Items', 'hostom-addon'),
        'prevent_empty' => false,
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $testimonial->get_controls(),
        'title_field' => '{{{ name }}}',
    ]
);


$this->end_controls_section();
