<?php

$this->start_controls_section(
    'layout_three_content',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_three']
        ]
    ]
);

$this->add_control(
    'layout_three_sec_title',
    [
        'label' => __('Section Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Awesome Title', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_three_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Awesome Sub Title', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_three_summary',
    [
        'label' => __('Summary Text', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Text', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_three_highlighted_text',
    [
        'label' => __('Highligted Text', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Text', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_three_features',
    [
        'label' => __('Features', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'default' => __('<li class="team-details__list__item"><span class="team-details__list__item__name">Experience:</span> 23 Years</li>', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_three_image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$layout_three_porogressbar_list = new \Elementor\Repeater();

$layout_three_porogressbar_list->add_control(
    'title',
    [
        'label' => __('Progressbar Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Progressbar Text', 'hostom-addon'),
        'default' => __('Digital Marketing', 'hostom-addon'),
        'label_block' => true
    ]
);

$layout_three_porogressbar_list->add_control(
    'count',
    [
        'label' => __('Progressbar Count', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
            'count' => [
                'min' => 1,
                'max' => 100,
                'step' => 1,
            ],
        ],
        'default' => [
            'unit' => 'count',
            'size' => 75,
        ],
    ]
);

$this->add_control(
    'layout_three_porogressbar_list',
    [
        'label' => __('Progressbar Lists', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_porogressbar_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$layout_three_social_icons = new \Elementor\Repeater();

$layout_three_social_icons->add_control(
    'social_icon',
    [
        'label' => __('Select Icon', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'fab fa-facebook-f',
            'library' => 'brand',
        ],
        'label_block' => true,
    ]
);

$layout_three_social_icons->add_control(
    'social_url',
    [
        'label' => __('Add Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'layout_three_social_icons',
    [
        'label' => __('Social Icons', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_social_icons->get_controls(),
        'prevent_empty' => false,
        'default' => [
            [
                'social_url' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ],
        ],
    ]
);

$this->end_controls_section();
