<?php

$this->start_controls_section(
    'layout_five_content',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_five'
        ]
    ]
);

$layout_five_team = new \Elementor\Repeater();

$layout_five_team->add_control(
    'name',
    [
        'label' => __('Name', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Michale smith', 'hostom-addon'),
        'label_block' => true,
    ]
);

hostom_elementor_heading_option($layout_five_team, 'Team Name', 'h3', 'layout_five');

$layout_five_team->add_control(
    'designation',
    [
        'label' => __('Designation', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('Mayor', 'hostom-addon'),
    ]
);

$layout_five_team->add_control(
    'url',
    [
        'label' => __('Url', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'hostom-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => true,
        ],
        'show_label' => false,
    ]
);

$layout_five_team->add_control(
    'social_network',
    [
        'label' => __('Social NetWork', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
        'default' => wp_kses('<a href="https://twitter.com/"><i class="fab fa-twitter"></i></a>', 'hostom_allowed_tags')
    ]
);


$layout_five_team->add_control(
    'image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);


$this->add_control(
    'layout_five_team_items',
    [
        'label' => __('Team', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_five_team->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ name }}}',
    ]
);

$this->end_controls_section();
