<?php

//content
$this->start_controls_section(
    'content_three',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$this->add_control(
    'layout_three_sec_title',
    [
        'label' => __('Section Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Title', 'h3', 'layout_three');

$this->add_control(
    'layout_three_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'hostom-addon'),
        'default' => __('Default Sub Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Sub Title', 'h6', 'layout_three');

$layout_three_tab_list = new \Elementor\Repeater();

$layout_three_tab_list->add_control(
    'name',
    [
        'label' => __('Name', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Name', 'hostom-addon'),
        'default' => __('Faster Server', 'hostom-addon'),
    ]
);

$layout_three_tab_list->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

$layout_three_tab_list->add_control(
    'summary',
    [
        'label' => __('Summary', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Summary', 'hostom-addon'),
        'default' => __('Default Text', 'hostom-addon'),
    ]
);

$layout_three_tab_list->add_control(
    'feature',
    [
        'label' => __('Feature', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'rows' => '2',
        'placeholder' => __('Add Feature', 'hostom-addon'),
        'default' => __('<li class="benefits-fore__list__item">Many variations of passages of Lorem Ipsum </li>', 'hostom-addon'),
    ]
);


$this->add_control(
    'layout_three_tab_list',
    [
        'label' => __('Tab Lists', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_tab_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ name }}}',
    ]
);

$this->add_control(
    'layout_three_domain_info',
    [
        'label' => __('Domain Info', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'rows' => '2',
        'placeholder' => __('Add Domain Info', 'hostom-addon'),
        'default' => __('.com <br> domain', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_three_domain_price',
    [
        'label' => __('Domain Price', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'rows' => '2',
        'placeholder' => __('Add Domain Price', 'hostom-addon'),
        'default' => __('$30 only', 'hostom-addon'),
    ]
);

$this->add_control(
    'layout_three_image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'layout_three_shape',
    [
        'label' => __('Shape', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->end_controls_section();
