<?php

//content
$this->start_controls_section(
    'content_one',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Title', 'h3', 'layout_one');

$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'hostom-addon'),
        'default' => __('Default Sub Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($this, 'Section Sub Title', 'h6', 'layout_one');

$tab_list = new \Elementor\Repeater();

$tab_list->add_control(
    'name',
    [
        'label' => __('Name', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Name', 'hostom-addon'),
        'default' => __('Faster Server', 'hostom-addon'),
    ]
);

$tab_list->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'hostom-addon'),
        'default' => __('Default Title', 'hostom-addon'),
    ]
);

hostom_elementor_heading_option($tab_list, 'Title', 'h3', 'layout_one');

$tab_list->add_control(
    'summary',
    [
        'label' => __('Summary', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Summary', 'hostom-addon'),
        'default' => __('Default Text', 'hostom-addon'),
    ]
);

$tab_list->add_control(
    'feature',
    [
        'label' => __('Feature', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::CODE,
        'rows' => '2',
        'placeholder' => __('Add Feature', 'hostom-addon'),
        'default' => __('<li class="benefits-one__list__item">Many variations of passages of Lorem Ipsum </li>', 'hostom-addon'),
    ]
);


$tab_list->add_control(
    'image',
    [
        'label' => __('Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'tab_list',
    [
        'label' => __('Tab Lists', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $tab_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);


$this->end_controls_section();
