<?php

$this->start_controls_section(
    'layout_two_content_section',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'layout_two_title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Default Title', 'hostom-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'layout_two_summary',
    [
        'label' => __('Summary Text', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Default Text', 'hostom-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'layout_two_mailchimp_url',
    [
        'label' => __('Add Mailchimp URL', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
        'label_block' => true
    ]
);

$this->add_control(
    'layout_two_mc_input_placeholder',
    [
        'label' => __('Input Placeholder Text', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Email address', 'hostom-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'layout_two_btn_label',
    [
        'label' => __('Button Label', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Subscribe', 'hostom-addon'),
        'label_block' => true
    ]
);


$this->add_control(
    'layout_two_image',
    [
        'label' => __('Add Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'layout_two_bg_image',
    [
        'label' => __('Add Background Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);


$this->end_controls_section();
