<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Content', 'hostom-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'title',
    [
        'label' => __('Title', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Default Title', 'hostom-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'mailchimp_url',
    [
        'label' => __('Add Mailchimp URL', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '#',
        'label_block' => true
    ]
);

$this->add_control(
    'mc_input_placeholder',
    [
        'label' => __('Input Placeholder Text', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Email address', 'hostom-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'btn_label',
    [
        'label' => __('Button Label', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Subscribe', 'hostom-addon'),
        'label_block' => true
    ]
);

$this->add_control(
    'icon_image',
    [
        'label' => __('Icon Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'image',
    [
        'label' => __('Add Image', 'hostom-addon'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);


$this->end_controls_section();
